DECLARE FUNCTION ischanbanned% (chn%, chknick%)
DECLARE FUNCTION addchanban% (chn%, banhost$)
DECLARE FUNCTION matchban% (chknick%, chkmask$)
DECLARE SUB makechanadmin (cval%, nval%, fval%)
DECLARE SUB makedeadmin (cval%, nval%, fval%)
DECLARE SUB makedeowner (cval%, nval%, fval%)
DECLARE SUB makechandehalfop (cval%, nval%, fval%)
DECLARE FUNCTION ischanmode% (chanval%, modeval$)
DECLARE FUNCTION isusermode% (nickval%, modeval$)
DECLARE FUNCTION isuserchanmode% (nickval%, chanval%, modeval$)
DECLARE SUB makechanowner (cval%, nval%, fval%)
DECLARE SUB makechanhalfop (cval%, nval%, fval%)
DECLARE FUNCTION ParseHelp$ (origtext$)
DECLARE SUB makechanvoice (cval%, nval%, fval%)
DECLARE SUB makedevoice (cval%, nval%, fval%)
DECLARE FUNCTION MakeLink$ (linkurl$)
DECLARE FUNCTION CheckAdminUsername% (ou$)
DECLARE FUNCTION ConvFromForm$ (inputdata$)
DECLARE FUNCTION FullHostMask$ (hvalue%)
DECLARE SUB OutBuffer (whichuser%, txtbuff$)
DECLARE FUNCTION UnixTimeEnc& (dateval AS STRING, timeval AS LONG)
DECLARE SUB KillClient (killwho%, reason$, killer$)
DECLARE SUB makedeop (cval%, nval%, fval%)
DECLARE SUB makechanop (cval%, nval%, fval%)
DECLARE SUB DoModeAdd (handval%, newmodes$)
DECLARE SUB remusermode (handval%, chkmode$)
DECLARE SUB ShowUserModes (handval%)
DECLARE FUNCTION Masker$ (actual$)
DECLARE SUB DoModeChange (handval%)
DECLARE FUNCTION validchan$ (chantocheck$)
DECLARE FUNCTION validnick$ (nicktocheck$)
DECLARE SUB DoNewPing (whichhand%, t!)
DECLARE FUNCTION chancount% ()
DECLARE FUNCTION createchan% ()
DECLARE SUB killchannel (whichchan%)
DECLARE FUNCTION ChanExist% (checkname$)
DECLARE SUB DrawBar ()
DECLARE FUNCTION nickinuse% (checkname$)
DECLARE SUB broadcastmsg (tochan%, fromnick%, msgtext$)
DECLARE SUB nickchanger (whichuser%, changeto$)
DECLARE SUB remfromchan (whichchan%, whichnick%, quitmsg$)
DECLARE FUNCTION userlist$ (whichchan AS INTEGER)
DECLARE SUB addtochan (whichchan%, whichuser%)
DECLARE SUB SendError (sckhand%, errnum%, comd$)
DECLARE SUB AddLog (Text AS STRING)
TYPE Registers
     ax AS INTEGER
     bx AS INTEGER
     cx AS INTEGER
     dx AS INTEGER
     bp AS INTEGER
     si AS INTEGER
     di AS INTEGER
     flags AS INTEGER
     ds AS INTEGER
     es AS INTEGER
END TYPE

'Define custom data type for nTCP-related data.
TYPE nTCP
        Enabled AS INTEGER
        IntVector AS INTEGER
        ErrorCode AS INTEGER
        LocalIP AS LONG
        LocalNetmask AS LONG
        LocalGateway AS LONG
        LocalDNS AS LONG
        localdomain AS STRING * 256
        DomainLen AS INTEGER
        Timeserver AS LONG
        MTU AS INTEGER
        TTL AS INTEGER
        TOS AS INTEGER
        MSS AS INTEGER
        RWIN AS INTEGER
        FreeInputPkts AS INTEGER
        FreeOutputPkts AS INTEGER
        Timeout AS INTEGER
END TYPE

'Define custom error type constants and other frequently used values.
CONST errBadCall = 1
CONST errCritical = 2
CONST errNoHandles = 3
CONST errBadHandle = 4
CONST errTimeout = 5
CONST errBadSession = 6

CONST sckListening = 1
CONST sckOpen = 4
CONST sckClosed = 7
CONST sckFake = 255

DECLARE FUNCTION Conv2IP$ (DWord AS LONG)
DECLARE FUNCTION Conv2DWord$ (inString AS STRING)
DECLARE FUNCTION HighByte% (Word AS INTEGER)
DECLARE FUNCTION LowByte% (Word AS INTEGER)

DECLARE FUNCTION tcpInit% (Vector AS INTEGER)
DECLARE FUNCTION tcpConnect% (RemoteIP AS STRING, RemotePort AS INTEGER)
DECLARE FUNCTION tcpStatus% (tcpHandle AS INTEGER)
DECLARE FUNCTION MakeReg% (h AS INTEGER, l AS INTEGER)
DECLARE FUNCTION tcpListen% (ListenPort AS INTEGER)
DECLARE SUB AddBuffer (textadd AS STRING)
DECLARE SUB DrawScreen ()
DECLARE SUB tcpUnload ()
DECLARE SUB tcpSetTimeout (TimeoutSeconds AS INTEGER)
DECLARE SUB RegBlank ()
DECLARE FUNCTION tcpGetData$ (tcpHandle AS INTEGER)
DECLARE SUB tcpClose (tcpHandle AS INTEGER)
DECLARE FUNCTION tcpInBuffer% (tcpHandle AS INTEGER)
DECLARE FUNCTION tcpInputQueue% (tcpHandle AS INTEGER)
DECLARE FUNCTION tcpRemoteIP$ (tcpHandle AS INTEGER)
DECLARE SUB tcpSendData (tcpHandle AS INTEGER, Data2Send AS STRING)
DECLARE SUB tcpDoIO ()
DECLARE SUB showErrorMsg ()
DIM SHARED LocalScr(1 TO 23) AS STRING * 80

DECLARE SUB interruptx (intnum AS INTEGER, inreg AS Registers, outreg AS Registers)

DEFINT A-Z

'Dimension variables that are shared between all subroutines and functions.
DIM SHARED tcpCall AS Registers
DIM SHARED tcpReturn AS Registers
DIM SHARED tcpDriver AS nTCP
DIM SHARED isActive AS INTEGER
DIM SHARED strGetData AS STRING * 1500
DIM SHARED strSendData AS STRING * 1500

DIM SHARED LogBuffer(1 TO 14) AS STRING

'This makes all CPU-blocking calls timeout after 5 seconds.
tcpSetTimeout 5

dummy% = tcpInit(&H61)
SCREEN 0: WIDTH 80: COLOR 7, 0: CLS

DIM SHARED DoNickServ AS INTEGER
DIM SHARED DoOperServ AS INTEGER
DIM SHARED DoMemoServ AS INTEGER
DIM SHARED NickServHelp AS STRING
DIM SHARED timezone AS LONG
DIM SHARED secondofday AS LONG
DIM SHARED maxhand AS INTEGER
DIM SHARED hands(19) AS INTEGER
DIM SHARED buffer(19) AS STRING
DIM SHARED nick(19) AS STRING
DIM SHARED userhost(19) AS STRING
DIM SHARED realname(19) AS STRING
DIM SHARED vhost(19) AS STRING
DIM SHARED verified(19) AS INTEGER
DIM SHARED usermodes(19) AS STRING
DIM SHARED userchanmodes(19, 1 TO 20) AS STRING
DIM SHARED userlevels(99) AS STRING
DIM SHARED isregistered(19) AS INTEGER
DIM SHARED hostresolved(19) AS INTEGER
DIM SHARED SendBuffer(19) AS STRING
DIM SHARED localdomain$
DIM SHARED nicksinchan(1 TO 10) AS STRING
DIM SHARED chans(1 TO 10) AS STRING
DIM SHARED chanmodes(1 TO 10) AS STRING
DIM SHARED Topic(1 TO 10) AS STRING
DIM SHARED topiclen%
DIM SHARED topicwriter(1 TO 10) AS STRING
DIM SHARED topictime(1 TO 10) AS LONG
DIM SHARED banlist(1 TO 10, 1 TO 20) AS STRING
DIM SHARED bancount(1 TO 10) AS INTEGER
DIM SHARED nickservdb(1 TO 50, 4) AS STRING
DIM SHARED nsmatcher(19) AS INTEGER
DIM SHARED nschktime!(19)
DIM SHARED onlinecount AS INTEGER
DIM SHARED motd AS STRING
DIM SHARED pinginterval!
DIM SHARED pingtimeout!
DIM SHARED lastping!(19)
DIM SHARED nextping!(19)
DIM SHARED waituntil!(19)
DIM SHARED gotpingresponse!(19)
DIM SHARED pinglag!(19)
DIM SHARED network$
DIM SHARED handdesc$(19)
DIM SHARED startview%
DIM SHARED stats(19)
DIM SHARED version(19) AS STRING
DIM SHARED nicklen%
DIM SHARED maxchannel%
DIM SHARED maskhosts%
DIM SHARED allownick$
DIM SHARED allowchan$
DIM SHARED idlesince(19) AS LONG
DIM SHARED signontime(19) AS LONG
DIM SHARED idletime AS LONG
DIM SHARED serverstarted AS LONG

DIM SHARED debugger AS STRING

DIM SHARED interact AS INTEGER

PRINT "DOSIRCD v1.0 beta [Build 80208]"
PRINT "(c)2008 Mike Chambers - http://www.rubbermallet.org/"
PRINT
PRINT "Reading configuration from DOSIRCD.INI..."
OPEN "CONF\DOSIRCD.INI" FOR INPUT AS #1
DO UNTIL EOF(1)
        LINE INPUT #1, tmpin$
        tmpin$ = RTRIM$(LTRIM$(tmpin$))
        IF LEFT$(tmpin$, 1) <> "#" THEN
                xp = INSTR(1, tmpin$, "=")
                IF xp > 0 THEN
                        var1$ = RTRIM$(LEFT$(tmpin$, xp - 1))
                        var2$ = LTRIM$(MID$(tmpin$, xp + 1))
                        SELECT CASE LCASE$(var1$)
                                CASE "timezone"
                                        IF LEFT$(var2$, 1) = "+" THEN var2$ = MID$(var2$, 2)
                                        timezone = VAL(var2$)

                                CASE "maskhosts"
                                        maskhosts% = VAL(var2$)

                                CASE "handles"
                                        maxhand = VAL(var2$)
                                        IF maxhand < 2 OR maxhand > 20 THEN
                                                PRINT "WARNING! You have specified in DOSIRCD.INI to allow" + STR$(maxhand) + " handles."
                                                PRINT "The number of handles must be between 2 and 20. Defaulting to 12 handles."
                                                maxhand = 12
                                        END IF

                                CASE "port"
                                        lport% = VAL(var2$)

                                CASE "localdomain"
                                        localdomain$ = var2$

                                CASE "pinginterval"
                                        pinginterval! = VAL(var2$)

                                CASE "pingtimeout"
                                        pingtimeout! = VAL(var2$)

                                CASE "network"
                                        network$ = var2$

                                CASE "nicklen"
                                        nicklen% = VAL(var2$)

                                CASE "maxchannel"
                                        maxchannel% = VAL(var2$)

                                CASE "nickchars"
                                        allownick$ = var2$

                                CASE "chanchars"
                                        allowchan$ = var2$

                                CASE "registerlevel"
                                        newreglevel% = VAL(var2$)

                                CASE "topiclen"
                                        topiclen% = VAL(var2$)

                                CASE "nickserv"
                                        DoNickServ = VAL(var2$)
                        END SELECT
                END IF
        END IF
LOOP
CLOSE #1
IF lport% = 0 THEN
        PRINT "WARNING! Could not determine TCP port from DOSIRCD.INI, defaulting to 6667!"
        lport% = 6667
END IF
IF localdomain$ = "" THEN
        PRINT "WARNING! Could not determine local domain from DOSIRCD.INI, defaulting"
        PRINT "to dosircd.localhost!"
        localdomain$ = "dosircd.localhost"
END IF
IF nicklen% < 8 OR nicklen% > 32 THEN
        PRINT "WARNING! Could not determine max nickname length from DOSIRCD.INI,"
        PRINT "defaulting to 32. Valid range is from 8 to 32."
        nicklen% = 32
END IF
IF maxchannel% < 1 OR maxchannel% > 10 THEN
        PRINT "WARNING! Could not determine max channels from DOSIRCD.INI,"
        PRINT "defaulting to 10. Valid range is from 1 to 10."
        maxchannel% = 10
END IF
PRINT "Will bind to port" + STR$(lport%) + " on interface " + Conv2IP$(tcpDriver.LocalIP)
PRINT
PRINT "Reading user level data from USERLEVS.INI..."
OPEN "CONF\USERLEVS.INI" FOR INPUT AS #1
DO UNTIL EOF(1)
        LINE INPUT #1, tmpin$
        xp = INSTR(1, tmpin$, "#")
        xp2 = INSTR(1, tmpin$, ":")
        IF xp < 1 AND xp2 > 0 AND tmpin$ <> "" THEN
                levnum = VAL(LEFT$(tmpin$, xp2 - 1))
                userlevels(levnum) = MID$(tmpin$, xp2 + 1)
        END IF
LOOP
CLOSE #1

PRINT
PRINT "Reading NickServ database from NICKSERV.INI..."
OPEN "CONF\NICKSERV.INI" FOR INPUT AS #1
nicknumber = 1
DO UNTIL EOF(1) OR nicknumber = 51
        LINE INPUT #1, tmpin$
        xp = INSTR(1, tmpin$, "#")
        xp2 = INSTR(1, tmpin$, ":")
        IF xp2 < 1 THEN xp2 = LEN(tmpin$) + 1
        IF xp < 1 THEN
                'nick:pass:level:vhost
                nickread$ = LEFT$(tmpin$, xp2 - 1)
                tmpin$ = MID$(tmpin$, xp2 + 1)

                xp2 = INSTR(1, tmpin$, ":")
                IF xp2 < 1 THEN xp2 = LEN(tmpin$) + 1
                passread$ = LEFT$(tmpin$, xp2 - 1)
                tmpin$ = MID$(tmpin$, xp2 + 1)

                xp2 = INSTR(1, tmpin$, ":")
                IF xp2 < 1 THEN xp2 = LEN(tmpin$) + 1
                levelread$ = LEFT$(tmpin$, xp2 - 1)
                tmpin$ = MID$(tmpin$, xp2 + 1)

                xp2 = INSTR(1, tmpin$, ":")
                IF xp2 < 1 THEN xp2 = LEN(tmpin$) + 1
                vhostread$ = LEFT$(tmpin$, xp2 - 1)
                tmpin$ = ""

                IF nickread$ <> "" AND passread$ <> "" AND levelread$ <> "" AND vhostread$ <> "" THEN
                        nickservdb(nicknumber, 1) = nickread$
                        nickservdb(nicknumber, 2) = passread$
                        nickservdb(nicknumber, 3) = MID$(STR$(VAL(levelread$)), 2)
                        nickservdb(nicknumber, 4) = vhostread$
                        nicknumber = nicknumber + 1
                END IF
        END IF
LOOP
CLOSE #1
IF nicknumber = 51 THEN
        PRINT "WARNING: 50 entries have been read, which is the limit. Any entries beyond"
        PRINT "50 have been ignored."
END IF

PRINT
PRINT "Loading message of the day from MOTD.TXT..."
OPEN "CONF\MOTD.TXT" FOR BINARY AS #1
IF LOF(1) > 2048 THEN
        motd = SPACE$(2048)
        GET #1, , motd
        PRINT "WARNING: MOTD.TXT is longer than 2048 bytes, so it has been truncated!"
ELSE
        IF LOF(1) > 0 THEN
                motd = SPACE$(LOF(1))
                GET #1, , motd
                PRINT "Read" + STR$(LEN(motd)) + " bytes from MOTD.TXT"
        ELSE
                PRINT "WARNING! MOTD.TXT is empty or does not exist!"
        END IF
END IF
CLOSE #1

PRINT
PRINT "Reading NICKSERV.HLP file into memory... ";
OPEN "SERVHELP\NICKSERV.HLP" FOR BINARY AS #1: NickServHelp = SPACE$(LOF(1)): GET #1, , NickServHelp: CLOSE #1
NickServHelp = ParseHelp(NickServHelp)
PRINT "OK!" + STR$(LEN(NickServHelp)) + " bytes."

IF INSTR(1, UCASE$(COMMAND$), "/NOWAIT") < 1 THEN
        PRINT
        PRINT "Ready to start the IRC server, press ENTER to continue or ESC to abort."
        PRINT "Will continue automatically in 5 seconds if you do not press a key."
        t! = TIMER
        DO
                SELECT CASE INKEY$
                        CASE CHR$(13)
                                EXIT DO
                        CASE CHR$(27)
                                END
                END SELECT
                IF TIMER - t! > 5 OR TIMER - t! < 0 THEN EXIT DO
        LOOP
END IF

SCREEN 0
COLOR 7, 0
WIDTH 80
CLS

FOR tmpcnt = 0 TO 19
        IF tmpcnt < 10 THEN pad$ = " " ELSE pad$ = ""
        handdesc$(tmpcnt) = LEFT$(pad$ + MID$(STR$(tmpcnt), 2) + ": Not used" + SPACE$(80), 80)
NEXT tmpcnt

LOCATE 1, 1, 0
COLOR 0, 7: PRINT SPACE$(80);
tmp$ = "DOSIRCD beta [Build 80208] (" + Conv2IP(tcpDriver.LocalIP) + ":" + MID$(STR$(lport%), 2) + ")"
LOCATE 1, 2, 0: PRINT tmp$
tmp$ = "(c)2008 Mike Chambers": LOCATE 1, 80 - LEN(tmp$), 0: PRINT tmp$;
COLOR 7, 0
LOCATE 10, 1, 0
PRINT STRING$(42, "") + "UP and DOWN arrows scroll connections"
AddLog "DOSIRCD beta [Build 80208] (c)2008 Mike Chambers"
AddLog "Distributed under the GNU GPL v3 license."
AddLog ""

AddLog ""
AddLog "Initializing server..."
FOR n = 0 TO maxhand - 1
        hands(n) = tcpListen(lport%)
NEXT n


DIM arglist(1 TO 3) AS STRING

AddLog "Server is online and listening for connections."
startdate$ = DATE$
starttime$ = TIME$
secondofday = FIX(TIMER)
serverstarted = UnixTimeEnc(DATE$, TIMER)
DO
        COLOR 0, 7: t$ = "     " + STR$(FRE(meep$)) + " bytes free RAM "
        LOCATE 1, 81 - LEN(t$): PRINT t$; : COLOR 7, 0

'        IF allowhttp = 1 THEN DoWebAdmin
        onlinecount = 0
        FOR n = 0 TO maxhand - 1
                'tcpDoIO
                laststat = stats(n)
                stats(n) = tcpStatus(n)
                SELECT CASE stats(n)
                        CASE 1
                                desc$ = "Waiting for connection..."
                       
                        CASE 4
                                idletime = FIX(UnixTimeEnc(DATE$, TIMER) - idlesince(n))
                                lagval$ = STR$(FIX(pinglag!(n) * 1000))
                                IF lagval$ = " 0" THEN lagval$ = " <5"
                                laginfo$ = " [lag" + lagval$ + " ms] - idle" + STR$(idletime) + " secs"
                                desc$ = tcpRemoteIP(n) + " - " + nick(n) + "!" + userhost(n) + "@" + vhost(n) + laginfo$
                                onlinecount = onlinecount + 1
                                IF isregistered(n) = 1 THEN 'maintenance stuff...
                                        IF hostresolved(n) = 0 AND LEFT$(userhost(n), 1) <> "~" THEN
                                                userhost(n) = "~" + userhost(n)
                                        END IF

                                        IF DoNickServ = 1 THEN
                                                IF nsmatcher(n) > 0 AND verified(n) = 1 THEN
                                                        IF nickservdb(nsmatcher(n), 4) <> "*" AND INSTR(1, usermodes(n), "v") < 1 AND INSTR(1, usermodes(n), "u") < 1 THEN
                                                                vhost(n) = nickservdb(nsmatcher(n), 4)
                                                                DoModeAdd n, "v"
                                                                tcpSendData n, ":NickServ!Services@" + localdomain$ + " NOTICE " + nick(n) + " :Your vhost of " + CHR$(2) + vhost(n) + CHR$(2) + " is now active." + CHR$(13) + CHR$(10)
                                                        END IF
                                                END IF
                                        END IF
                                END IF

                        CASE 7, 0
                                desc$ = "No connection."
                                tcpClose n 'Recycles handle for re-use.
                                FOR ny = 1 TO maxchannel%
                                        xp = INSTR(1, nicksinchan(ny), CHR$(n))
                                        IF xp > 0 THEN remfromchan ny, n, "Client exited or connection was reset by peer."
                                NEXT ny
                                buffer(n) = ""
                                hands(n) = tcpListen(lport%)
                                nick(n) = ""
                                verified(n) = 0
                                version(n) = "Unknown"
                                usermodes(n) = ""
                                userhost(n) = ""
                                realname(n) = ""
                                vhost(n) = ""
                                usermodes(n) = ""
                                isregistered(n) = 0
                                hostresolved(n) = 0
                                nsmatcher(n) = 0
                                SendBuffer(n) = ""
                                'idletime(n) = 0
                                signontime(n) = 0

                                FOR chk1% = 1 TO maxchannel%
                                        userchanmodes(n, chk1%) = ""
                                NEXT chk1%
                                IF laststat <> 7 AND laststat <> 0 THEN
                                        AddLog "- Connection closed on socket handle" + STR$(n) + ", called handle reset."
                                END IF
                CASE ELSE
                        desc$ = "UKNOWN status value of" + STR$(stats(n)) + " - this should never happen!"
                END SELECT
               
                IF n < 10 THEN pad$ = " " ELSE pad$ = ""
                handdesc$(n) = LEFT$(pad$ + MID$(STR$(n), 2) + ": " + desc$ + SPACE$(80), 80)

                IF interact = 0 THEN
                        LOCATE 2, 1, 0
                        FOR disphand = startview% TO startview% + 7
                                PRINT handdesc$(disphand);
                        NEXT disphand
                END IF

                IF UnixTimeEnc(DATE$, TIMER) - signontime(n) < 60 THEN gotpingreponse!(n) = 1

                IF stats(n) = 4 THEN
                        IF laststat = 1 THEN
                                signontime(n) = UnixTimeEnc(DATE$, TIMER)
                                'tcpDoIO
                                AddLog "- New connection from " + tcpRemoteIP(n) + " on socket handle" + STR$(n)
                                isregistered(n) = 0
                                hostresolved(n) = 0
                                nick(n) = ""
                                userhost(n) = ""
                                tcpSendData n, ":" + localdomain$ + " NOTICE AUTH :*** Welcome to the IRC server at " + localdomain$ + CHR$(13) + CHR$(10)
                                'i don't actually have IP to hostname resolution code written yet... will do later. for now just mark username with a ~
                                tcpSendData n, ":" + localdomain$ + " NOTICE AUTH :*** Looking up your hostname..." + CHR$(13) + CHR$(10)
                                tcpSendData n, ":" + localdomain$ + " NOTICE AUTH :*** Couldn't resolve your hostname; using your IP address instead" + CHR$(13) + CHR$(10)
                                tcpSendData n, ":" + localdomain$ + " NOTICE AUTH :*** Not checking ident; username prefixed with ~" + CHR$(13) + CHR$(10)
                                tcpSendData n, ":" + localdomain$ + " NOTICE AUTH :*** Please register a nickname and username to log in." + CHR$(13) + CHR$(10)
                              
                                gotpingresponse!(n) = 1
                                'DoNewPing n, t!
                                waituntil!(n) = TIMER + 90
                                lastping!(n) = 0
                                nextping!(n) = TIMER + 60
                                IF nextping!(n) > 863400 THEN nextping!(n) = 60
                                IF waituntil!(n) > 86340 THEN waituntil!(n) = 90
                                gotpingresponse!(n) = 1

                        ELSE
                                IF UnixTimeEnc(DATE$, TIMER) - signontime(n) < 10 THEN gotpingresponse!(n) = 1
                        END IF

                        t! = TIMER

                        IF t! > 86340 OR t! < 60 THEN
                                nextping!(n) = 60
                                lastping!(n) = 1
                                waituntil!(n) = 60 + pingtimeout!
                                gotpingresponse!(n) = 1
                        END IF

                        IF gotpingresponse!(n) = 0 AND t! - lastping!(n) > pingtimeout! THEN
                                IF UnixTimeEnc(DATE$, TIMER) - signontime(n) < 60 THEN
                                                tcpSendData n, "ERROR: " + nick(n) + "[" + tcpRemoteIP(n) + "] Ping timeout!" + CHR$(13) + CHR$(10)
                                                IF nick(n) <> "" THEN
                                                        FOR nt = 1 TO maxchannel%
                                                                IF INSTR(1, nicksinchan(nt), CHR$(n)) THEN
                                                                        remfromchan nt, n, "Ping timeout."
                                                                END IF
                                                        NEXT nt
                                                END IF
                                        tcpClose hands(n)
                                        buffer(n) = ""
                                END IF
                        END IF

                        t! = TIMER
                        IF t! > nextping!(n) AND t! < (86400 - pingtimeout!) AND gotpingresponse!(n) = 1 THEN
                                DoNewPing n, t!
                        END IF


                DO
                        IF INSTR(1, usermodes(n), "u") THEN
                                IF nschktime!(n) < 60 THEN
                                        IF TIMER > nschktime!(n) AND TIMER < 86340 THEN
                                                testednick$ = "no_nick" + MID$(STR$(n), 2)
                                                DO
                                                        dupecheck = -1
                                                        FOR chkdp = 0 TO maxhand - 1
                                                                IF LCASE$(testednick$) = LCASE$(nick(chkdp)) THEN
                                                                        dupecheck = chkdp
                                                                        testednick$ = testednick$ + "_"
                                                                END IF
                                                        NEXT chkdp
                                                LOOP UNTIL dupecheck = -1
                                                GOSUB switchnick
                                        END IF
                                ELSE
                                        IF TIMER > nschktime!(n) THEN
                                                testednick$ = "no_nick" + MID$(STR$(n), 2)
                                                DO
                                                        dupecheck = -1
                                                        FOR chkdp = 0 TO maxhand - 1
                                                                IF LCASE$(testednick$) = LCASE$(nick(chkdp)) THEN
                                                                        dupecheck = chkdp
                                                                        testednick$ = testednick$ + "_"
                                                                END IF
                                                        NEXT chkdp
                                                LOOP UNTIL dupecheck = -1
                                                GOSUB switchnick
                                        END IF
                                END IF
                        END IF

                        fullline$ = ""
                        DO
                                'tcpDoIO
                                IF LEN(buffer(n)) >= 2048 THEN 'avoids out of string space errors
                                        buffer(n) = ""
                                        tcpSendData n, ":" + localdomain$ + " NOTICE * :Your client has sent more than 2 KB to this server without a CR-LF signal." + CHR$(13) + CHR$(10)
                                        tcpSendData n, ":" + localdomain$ + " NOTICE * :I'm not sure what you're trying to do, but I don't like this so you are being automatically killed." + CHR$(13) + CHR$(10)
                                        args$ = "Auto-killed by server due to excessive buffering with no CR-LF!"
                                        FOR chkchan = 1 TO maxchannel%
                                                IF INSTR(1, nicksinchan(chkchan), CHR$(n)) THEN
                                                        remfromchan chkchan, n, args$
                                                END IF
                                        NEXT chkchan
                                        tcpSendData n, "ERROR :Closing link: " + nick(n) + "[" + tcpRemoteIP$(n) + "] (" + args$ + ")" + CHR$(13) + CHR$(10)
                                        tcpClose n
                                END IF
                                
                                IF DoNickServ = 1 THEN
                                        IF isregistered(n) = 1 AND nsmatcher(n) > 0 THEN
                                                IF nickservdb(nsmatcher(n), 2) = "*" THEN
                                                        OutBuffer n, ":NickServ!Services@" + localdomain$ + " NOTICE " + nick(n) + " :A server administrator has configured your entry in the " + CHR$(2) + "NickServ" + CHR$(2) + CHR$(13) + CHR$(10)
                                                        OutBuffer n, ":NickServ!Services@" + localdomain$ + " NOTICE " + nick(n) + " :database " + CHR$(2) + "WITHOUT" + CHR$(2) + " any password! If you would like this issue resolved," + CHR$(13) +  _
CHR$(10)
                                                        OutBuffer n, ":NickServ!Services@" + localdomain$ + " NOTICE " + nick(n) + " :need to contact an administrator!" + CHR$(13) + CHR$(10)
                                                        tcpSendData n, SendBuffer(n)
                                                        SendBuffer(n) = ""
                                                END IF
                                        END IF
                                END IF

                                tmp$ = tcpGetData(n)
                                
                                IF tmp$ <> "" THEN
                                        newtmp$ = ""
                                        FOR junkfilter = 1 TO LEN(tmp$)
                                                cchar = ASC(MID$(tmp$, junkfilter, 1))
                                                SELECT CASE cchar
                                                        CASE 0, 7, 8, 9, 11, 12, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 28, 29, 30, 31, 255
                                                                'those char values get filtered out.
                                                        CASE ELSE
                                                        newtmp$ = newtmp$ + CHR$(cchar)
                                                END SELECT
                                        NEXT junkfilter

                                        tmp$ = newtmp$
                                        newtmp$ = ""
                                        buffer(n) = buffer(n) + tmp$
                                ELSE
                                        EXIT DO
                                END IF
                        LOOP
                        IF INSTR(1, buffer(n), CHR$(10)) > 0 THEN
                                'AddLog tmp$
                               
                                DO UNTIL INSTR(1, buffer(n), CHR$(13)) < 1
                                        xp = INSTR(1, buffer(n), CHR$(13))
                                        IF xp > 0 THEN buffer(n) = LEFT$(buffer(n), xp - 1) + MID$(buffer(n), xp + 1)
                                LOOP
                                xp = INSTR(1, buffer(n), CHR$(10))
                                IF xp > 0 THEN fullline$ = LEFT$(buffer(n), xp - 1): buffer(n) = MID$(buffer(n), xp + 1)

                                'In the IRC RFC spec, servers should truncate incoming
                                'lines from the client if they are over 512 bytes.
                                'That includes the 2 bytes used at the end for the CR-LF,
                                'which means we will allow only 510 bytes after trimming.
                                IF LEN(fullline$) > 510 THEN fullline$ = LEFT$(fullline$, 510)
                        END IF

                IF fullline$ = "" THEN
                        EXIT DO
                ELSE
                        
                        xp = INSTR(1, fullline$, " "): IF xp < 1 THEN xp = LEN(fullline$) + 1
                        cmd$ = UCASE$(LEFT$(fullline$, xp - 1))
                        args$ = MID$(fullline$, xp + 1)
                       
                        IF cmd$ = "PONG" THEN
                                pinglag!(n) = TIMER - lastping!(n)
                                IF pinglag!(n) < 0 THEN pinglag!(n) = 0
                                gotpingresponse!(n) = 1
                        END IF
                        IF cmd$ = "PING" THEN
                                'reply to a client's ping to the server
                                tcpSendData n, "PONG " + args$ + CHR$(13) + CHR$(10)
                        END IF

                        IF cmd$ <> "PONG" AND cmd$ <> "PING" AND cmd$ <> "" THEN
                                idlesince(n) = UnixTimeEnc(DATE$, TIMER)
                        END IF

                        IF isregistered(n) = 0 THEN
                                SELECT CASE cmd$
                                CASE "PONG", "PING"

                                CASE "NICK"
                                        oldarg$ = args$
                                        args$ = validnick(args$)
                                        IF oldarg$ <> args$ THEN
                                                tcpSendData n, ":" + localdomain$ + " NOTICE * :The nick you provided, " + CHR$(2) + oldarg$ + CHR$(2) + " contained one or more invalid characters, and has been modified to " + CHR$(2) + args$ + CHR$( _
2) + CHR$(13) + CHR$(10)
                                                args$ = LEFT$(args$, nicklen%)
                                        END IF

                                        IF args$ = "" THEN
                                                SendError n, 461, cmd$
                                        ELSE
                                                IF nickinuse(args$) <> 1 THEN
                                                        nick(n) = args$
                                                ELSE
                                                        SendError n, 433, args$
                                                END IF
                                        END IF

                                CASE "USER"
                                        IF userhost(n) = "" THEN
                                                xp = INSTR(1, args$, " ")
                                                IF xp < 1 THEN
                                                        SendError n, 461, cmd$
                                                ELSE
                                                        xp2 = INSTR(1, args$, ":")
                                                        IF xp2 < 1 THEN xp2 = xp + 1
                                                        userhost(n) = LEFT$(args$, xp - 1)
                                                        realname(n) = MID$(args$, xp2 + 1)
                                                END IF
                                        ELSE
                                                SendError n, 462, ""
                                        END IF
                                        
                                CASE ELSE
                                        SendError n, 451, cmd$
                                END SELECT

                                IF userhost(n) <> "" AND nick(n) <> "" THEN
                                        isregistered(n) = 1
                                        GOSUB loginsequence:
                                END IF
                        ELSE
                                IF LEFT$(args$, 1) = ":" THEN args$ = MID$(args$, 2)

                                'IF LCASE$(nick(n)) = "king_crimson" OR LCASE$(nick(n)) = "mike" THEN
                                '        AddLog nick(n) + " < " + cmd$ + " " + args$
                                'END IF

                                SELECT CASE cmd$
                                CASE "PING"
                                        'was taken care of in above code.

                                CASE "KICK"
                                        tcpSendData n, ":System!Services@" + localdomain$ + " NOTICE " + nick(n) + " :Unable to KICK. DOSIRCd is still under heavy development." + CHR$(13) + CHR$(10)

                                CASE "WHOIS"
                                        xp = INSTR(1, args$, " ")
                                        IF xp > 0 THEN 'client wants to forward request to another server... we don't like this if it doesn't match localdomain$
                                                fwdto$ = LEFT$(args$, xp - 1)
                                                nicklist$ = MID$(args$, xp + 1)
                                        ELSE
                                                fwdto$ = localdomain$ 'this IRCd doesn't handle multiple servers, but let's fake it. at least not yet, and i don't see a reason to.
                                                nicklist$ = args$
                                        END IF
                                        IF LEFT$(nicklist$, 1) = ":" THEN nicklist$ = MID$(nicklist$, 2)
                                        IF LCASE$(fwdto$) <> LCASE$(localdomain$) THEN
                                                SendError n, 402, fwdto$
                                        ELSE
                                                stat = tcpStatus(n)
                                                IF stat <> sckOpen THEN
                                                        tcpClose n
                                                        EXIT DO
                                                END IF

                                                DO UNTIL nicklist$ = ""
                                                        'tcpDoIO
                                                        stat = tcpStatus(n)
                                                        IF stat <> sckOpen THEN
                                                                tcpClose n
                                                                EXIT DO
                                                        END IF
                                                        whoisnick = -1
                                                        xp = INSTR(1, nicklist$, ",")
                                                        IF xp < 1 THEN xp = LEN(nicklist$) + 1
                                                        whoischeck$ = LEFT$(nicklist$, xp - 1)
                                                        nicklist$ = MID$(nicklist$, xp + 1)
                                                        FOR numb = 0 TO maxhand - 1
                                                                IF LCASE$(nick(numb)) = LCASE$(whoischeck$) THEN
                                                                        whoisnick = numb
                                                                        EXIT FOR
                                                                END IF
                                                        NEXT numb
                                                        IF whoisnick = -1 THEN 'nick not found, send error back.
                                                                SendError n, 401, whoischeck$
                                                        ELSE
                                                                'this code generates a successful WHOIS reply:
                                                                tmpchanlist$ = ""
                                                                FOR numb = 1 TO maxchannel%
                                                                        IF INSTR(1, nicksinchan(numb), CHR$(whoisnick)) > 0 THEN
                                                                                tmpchanlist$ = tmpchanlist$ + chans(numb) + " "
                                                                        END IF
                                                                NEXT numb
                                                                IF RIGHT$(tmpchanlist$, 1) = " " THEN tmpchanlist$ = LEFT$(tmpchanlist$, LEN(tmpchanlist$) - 1)
                                                                tcpSendData n, ":" + localdomain$ + " 311 " + nick(n) + " " + whoischeck$ + " " + userhost(whoisnick) + " " + vhost(whoisnick) + " * :" + realname(whoisnick) + CHR$(13) + CHR$(10)
                                                                IF tmpchanlist$ <> "" THEN tcpSendData n, ":" + localdomain$ + " 319 " + nick(n) + " " + whoischeck$ + " :" + tmpchanlist$ + CHR$(13) + CHR$(10)
                                                                tcpSendData n, ":" + localdomain$ + " 312 " + nick(n) + " " + whoischeck$ + " " + localdomain$ + " :" + network$ + " " + CHR$(2) + "(Using IRC client: " + version(whoisnick) + ")" +  _
CHR$(2) + CHR$(13) + CHR$(10)
                                                                tcpSendData n, ":" + localdomain$ + " 317 " + nick(n) + " " + whoischeck$ + STR$(idletime) + STR$(signontime(n)) + " :seconds idle, signon time" + CHR$(13) + CHR$(10)
                                                                tcpSendData n, ":" + localdomain$ + " 318 " + nick(n) + " " + whoischeck$ + " :End of /WHOIS list." + CHR$(13) + CHR$(10)
                                                                'end WHOIS reply code
                                                        END IF
                                                LOOP
                                        END IF

                                CASE "PONG"
                                        gotpingresponse(n) = 1

                                CASE "NAMES"
                                        chanstocheck$ = args$
                                        DO UNTIL chanstocheck$ = ""
                                                xp = INSTR(1, chanstocheck$, ",")
                                                IF xp < 1 THEN xp = LEN(chanstocheck$) + 1
                                                cchan$ = LEFT$(chanstocheck$, xp - 1)
                                                chanstocheck$ = MID$(chanstocheck$, xp + 1)
                                               
                                                FOR chanvalue% = 1 TO maxchannel%
                                                        IF LCASE$(cchan$) = LCASE$(chans(chanvalue%)) THEN EXIT FOR
                                                NEXT chanvalue%
                                                
                                                IF chanvalue% <= maxchannel% AND tmpuserlist$ <> "" THEN
                                                        tmpuserlist$ = userlist(chanvalue%)
                                                        tcpSendData n, ":" + localdomain$ + " 353 " + nick(n) + " = " + cchan$ + " :" + tmpuserlist$ + CHR$(13) + CHR$(10)
                                                        tcpSendData n, ":" + localdomain$ + " 366 " + nick(n) + " " + cchan$ + " :End of /NAMES list" + CHR$(13) + CHR$(10)
                                                ELSE
                                                        tcpSendData n, ":" + localdomain$ + " 366 " + nick(n) + " " + cchan$ + " :End of /NAMES list" + CHR$(13) + CHR$(10)
                                                END IF

                                                stat = tcpStatus(n)
                                                IF stat <> sckOpen THEN
                                                        tcpClose n
                                                        EXIT DO
                                                END IF
                                        LOOP

                                CASE "USER"
                                        xp = INSTR(1, args$, " ")
                                        IF xp < 1 THEN
                                                SendError n, 461, cmd$
                                        ELSE
                                                xp2 = INSTR(1, args$, ":")
                                                IF xp2 < 1 THEN xp2 = xp + 1
                                                userhost(n) = LEFT$(args$, xp - 1)
                                                realname(n) = MID$(args$, xp2 + 1)
                                        END IF

                                CASE "NICK"
                                        oldarg$ = args$
                                        args$ = validnick(args$)
                                        IF oldarg$ <> args$ THEN
                                                tcpSendData n, ":" + localdomain$ + " NOTICE * :The nick you provided, " + CHR$(2) + oldarg$ + CHR$(2) + " contained one or more invalid characters, and has been modified to " + CHR$(2) + args$ + CHR$( _
2) + CHR$(13) + CHR$(10)
                                        END IF

                                        IF args$ = "" THEN
                                                SendError n, 451, cmd$
                                        ELSE
                                                args$ = LEFT$(args$, nicklen%)
                                                IF nickinuse(args$) = 0 THEN
                                                        xp = INSTR(1, args$, " ")
                                                        IF xp < 1 THEN xp = LEN(args$) + 1
                                                        testednick$ = LEFT$(args$, xp - 1)
                                                        GOSUB switchnick:
                                                        IF userhost(n) = "" THEN userhost(n) = nick(n)
                                                        GOSUB nickservdbchecker:
                                                ELSE
                                                        tcpSendData n, ":" + localdomain$ + " 433 " + nick(n) + " " + args$ + " :Nickname already in use" + CHR$(13) + CHR$(10)
                                                END IF
                                        END IF

                                CASE "JOIN"
                                fulljoinlist$ = args$
                                DO
                                        xpcomma = INSTR(1, fulljoinlist$, ",")
                                        IF xpcomma < 1 THEN xpcomma = LEN(fulljoinlist$) + 1
                                        args$ = LEFT$(fulljoinlist$, xpcomma - 1)
                                        fulljoinlist$ = MID$(fulljoinlist$, xpcomma + 1)

                                        oldarg$ = args$
                                        args$ = validchan(args$)
                                        IF oldarg$ <> args$ THEN
                                                tcpSendData n, ":" + localdomain$ + " NOTICE * :The channel name you provided, " + CHR$(2) + oldarg$ + CHR$(2) + " contained one or more invalid characters, and has been modified to " + CHR$(2) + args$ _
 + CHR$(2) + CHR$(13) + CHR$(10)
                                        END IF

                                        IF args$ = "" THEN
                                                SendError n, 451, cmd$
                                        ELSE
                                                exists = ChanExist(args$)
                                                        IF exists = 0 AND exists < 11 THEN
                                                                IF chancount = 10 THEN
                                                                        tcpSendData n, ":" + localdomain$ + " 403 " + args$ + " :Cannot create a new channel. Maximum channel count has already been reached." + CHR$(13) + CHR$(10)
                                                                ELSE
                                                                        newchan% = createchan
                                                                        chans(newchan%) = args$
                                                                        nicksinchan(newchan%) = ""
                                                                        addtochan newchan%, n
                                                                END IF
                                                        ELSE
                                                                IF INSTR(1, nicksinchan(exists), CHR$(n)) < 1 THEN
                                                                        userchanmodes(n, exists) = ""
                                                                        addtochan exists, n
                                                                END IF
                                                        END IF
                                        END IF
                                LOOP UNTIL fulljoinlist$ = ""

                                CASE "PART"
                                xpcolon = INSTR(1, args$, ":")
                                IF xpcolon > 0 THEN partreason$ = " :" + MID$(args$, xpcolon + 1): args$ = LEFT$(args$, xpcolon - 2)
                                fullpartlist$ = args$
                                DO
                                        xpcomma = INSTR(1, fullpartlist$, ",")
                                        IF xpcomma < 1 THEN xpcomma = LEN(fullpartlist$) + 1
                                        args$ = LEFT$(fullpartlist$, xpcomma - 1)
                                        fullpartlist$ = MID$(fullpartlist$, xpcomma + 1)

                                        IF args$ = "" THEN
                                                SendError n, 451, cmd$
                                        ELSE
                                                exists = ChanExist(args$)
                                                IF exists < 1 OR exists > 10 THEN
                                                        SendError n, 442, args$
                                                ELSE
                                                        IF INSTR(1, nicksinchan(exists), CHR$(n)) > 0 THEN
                                                                remfromchan exists, n + 10000, partreason$
                                                                tcpSendData n, ":" + FullHostMask(n) + " PART " + chans(exists) + partreason$ + CHR$(13) + CHR$(10)
                                                        ELSE
                                                                SendError n, 442, args$
                                                        END IF
                                                END IF
                                        END IF
                                LOOP UNTIL fullpartlist$ = ""
                               
                                CASE "MODE"
                                        xpspace = INSTR(1, args$, " ")
                                        IF xpspace < 1 THEN xpspace = LEN(args$) + 1
                                        args2$ = MID$(args$, xpspace + 1)
                                        args$ = LEFT$(args$, xpspace - 1)
                                        IF args$ = "" THEN
                                                SendError n, 451, cmd$
                                        ELSE
                                                IF LEFT$(args$, 1) = "#" THEN
                                                        exists = ChanExist(args$)
                                                        IF exists = 0 THEN
                                                                SendError n, 442, args$
                                                        ELSE
                                                                IF INSTR(1, nicksinchan(exists), CHR$(n)) > 0 THEN
                                                                        IF args2$ = "" OR args2$ = "+b" THEN 'just requesting mode list
                                                                                IF chanmodes(exists) <> "" THEN givemodes$ = "+" + chanmodes(exists) ELSE givemodes$ = ""
                                                                                tcpSendData n, ":" + localdomain$ + " 324 " + nick(n) + " " + chans(exists) + " " + givemodes$ + CHR$(13) + CHR$(10)
                                                                                IF args2$ = "+b" THEN 'also requested banlist
                                                                                        'make this laterz
                                                                                        tcpSendData n, ":" + localdomain$ + " 368 " + nick(n) + " " + chans(exists) + " :End of channel ban list." + CHR$(13) + CHR$(10)
                                                                                END IF

                                                                        ELSE 'trying to set modes on channel
                                                                                allowset = 0
                                                                                IF isusermode(n, "oa") THEN allowset = 1
                                                                                IF isuserchanmode(n, exists, "q") THEN allowset = 1
                                                                                
                                                                                        xps = INSTR(1, args2$, " ")
                                                                                        IF xps < 1 THEN xps = LEN(args2$) + 1
                                                                                        lastargs$ = MID$(args2$, xps + 1)
                                                                                        args2$ = LEFT$(args2$, xps - 1)

                                                                                        IF lastargs$ <> "" THEN
                                                                                                FOR argpos = 1 TO 3
                                                                                                        xps = INSTR(1, lastargs$, " ")
                                                                                                        IF xps < 1 THEN xps = LEN(lastargs$) + 1
                                                                                                        arglist(argpos) = LEFT$(lastargs$, xps - 1)
                                                                                                        lastargs$ = MID$(lastargs$, xps + 1)
                                                                                                NEXT argpos
                                                                                                lastargs$ = ""
                                                                                        ELSE
                                                                                                arglist(1) = "": arglist(2) = "": arglist(3) = ""
                                                                                        END IF

                                                                                        pre$ = ""
                                                                                        argpos = 1
                                                                                        SELECT CASE LEFT$(args2$, 1)
                                                                                                CASE "+" 'add modes
                                                                                                        pre$ = "+"
                                                                                                        deld$ = ""
                                                                                                        FOR chkm = 2 TO LEN(args2$)
                                                                                                                curmode$ = MID$(args2$, chkm, 1)
                                                                                                                allowset = 0
                                                                                                                IF isusermode(n, "oa") THEN allowset = 1
                                                                                                                IF isuserchanmode(n, exists, "q") THEN allowset = 1
                                                                                                                IF ischanmode(exists, curmode$) = 0 THEN
                                                                                                                        SELECT CASE curmode$
                                                                                                                                'CASE "C", "m", "n", "p", "s"
                                                                                                                                'CASE "b" 'ban stuff
                                                                                                                                '                'trying to add a ban, not just requesting banlist
                                                                                                                                '                IF argpos > 0 AND argpos < 4 THEN
                                                                                                                                '                        IF arglist(argpos) <> "" THEN
                                                                                                                                '                                FOR chkn = 1 TO LEN(nicksinchan(exists))
                                                                                                                                '                                        nval = ASC(MID$(nicksinchan(exists), chkn, 1))
                                                                                                                                '                                        IF isuserchanmode(n, exists, "qao") THEN allowset = 1
                                                                                                                                '                                        IF allowset = 1 THEN
                                                                                                                                '                                                result% = addchanban(exists, arglist(argpos))
                                                                                                                                '                                                IF result% = 1 THEN
                                                                                                                                '                                                        FOR nubb = 1 TO LEN(nicksinchan(exists))
                                                                                                                                 _
'                                                                tcpSendData ASC(MID$(nicksinchan(exists), nubb, 1)), ":" + FullHostMask(n) + " MODE " + chans(exists) + " +b " + arglist(argpos) + CHR$(13) + CHR$(10)
                                                                                                                                '                                                        NEXT nubb
                                                                                                                                '                                                END IF
                                                                                                                                '                                        END IF
                                                                                                                                '                                NEXT chkn
                                                                                                                                '                                argpos = argpos + 1
                                                                                                                                '                        END IF
                                                                                                                                '                END IF

                                                                                                                                CASE "m", "p", "s" 'setting moderated, private, or secret
                                                                                                                                        IF isuserchanmode(n, exists, "qao") THEN allowset = 1
                                                                                                                                        IF allowset = 1 THEN
                                                                                                                                                chanmodes(exists) = chanmodes(exists) + curmode$
                                                                                                                                                deld$ = deld$ + curmode$
                                                                                                                                        END IF

                                                                                                                                CASE "o" 'setting somebody as an op
                                                                                                                                        IF argpos > 0 AND argpos < 4 THEN
                                                                                                                                                IF arglist(argpos) <> "" THEN
                                                                                                                                                        FOR chkn = 1 TO LEN(nicksinchan(exists))
                                                                                                                                                                nval = ASC(MID$(nicksinchan(exists), chkn, 1))
                                                                                                                                                                IF isuserchanmode(n, exists, "qao") THEN allowset = 1
                                                                                                                                                                IF allowset = 1 AND LCASE$(arglist(argpos)) = LCASE$(nick(nval)) THEN
                                                                                                                                                                        makechanop exists, nval, n
                                                                                                                                                                END IF
                                                                                                                                                        NEXT chkn
                                                                                                                                                        argpos = argpos + 1
                                                                                                                                                END IF
                                                                                                                                        END IF

                                                                                                                                CASE "q"
                                                                                                                                        IF argpos > 0 AND argpos < 4 THEN
                                                                                                                                                IF arglist(argpos) <> "" THEN
                                                                                                                                                        FOR chkn = 1 TO LEN(nicksinchan(exists))
                                                                                                                                                                nval = ASC(MID$(nicksinchan(exists), chkn, 1))
                                                                                                                                                                allowset = 0
                                                                                                                                                                IF isusermode(n, "ao") THEN allowset = 1
                                                                                                                                                                IF isuserchanmode(n, exists, "q") THEN allowset = 1
                                                                                                                                                                IF allowset = 1 AND LCASE$(arglist(argpos)) = LCASE$(nick(nval)) THEN
                                                                                                                                                                        makechanowner exists, nval, n
                                                                                                                                                                END IF
                                                                                                                                                        NEXT chkn
                                                                                                                                                        argpos = argpos + 1
                                                                                                                                                END IF
                                                                                                                                        END IF

                                                                                                                                CASE "a"
                                                                                                                                        IF argpos > 0 AND argpos < 4 THEN
                                                                                                                                                IF arglist(argpos) <> "" THEN
                                                                                                                                                        FOR chkn = 1 TO LEN(nicksinchan(exists))
                                                                                                                                                                nval = ASC(MID$(nicksinchan(exists), chkn, 1))
                                                                                                                                                                allowset = 0
                                                                                                                                                                IF isusermode(n, "ao") THEN allowset = 1
                                                                                                                                                                IF isuserchanmode(n, exists, "q") THEN allowset = 1 ELSE allowset = 0
                                                                                                                                                                IF allowset = 1 AND LCASE$(arglist(argpos)) = LCASE$(nick(nval)) THEN
                                                                                                                                                                        makechanadmin exists, nval, n
                                                                                                                                                                END IF
                                                                                                                                                        NEXT chkn
                                                                                                                                                        argpos = argpos + 1
                                                                                                                                                END IF
                                                                                                                                        END IF

                                                                                                                                CASE "h"
                                                                                                                                        IF argpos > 0 AND argpos < 4 THEN
                                                                                                                                                IF arglist(argpos) <> "" THEN
                                                                                                                                                        FOR chkn = 1 TO LEN(nicksinchan(exists))
                                                                                                                                                                nval = ASC(MID$(nicksinchan(exists), chkn, 1))
                                                                                                                                                                allowset = 0
                                                                                                                                                                IF isusermode(n, "ao") THEN allowset = 1
                                                                                                                                                                IF isuserchanmode(n, exists, "oaq") THEN allowset = 1
                                                                                                                                                                IF isuserchanmode(nval, exists, "h") THEN allowset = 0
                                                                                                                                                                IF allowset = 1 AND LCASE$(arglist(argpos)) = LCASE$(nick(nval)) THEN
                                                                                                                                                                        makechanhalfop exists, nval, n
                                                                                                                                                                END IF
                                                                                                                                                        NEXT chkn
                                                                                                                                                        argpos = argpos + 1
                                                                                                                                                END IF
                                                                                                                                        END IF


                                                                                                                                CASE "v"
                                                                                                                                        IF argpos > 0 AND argpos < 4 THEN
                                                                                                                                                IF arglist(argpos) <> "" THEN
                                                                                                                                                        FOR chkn = 1 TO LEN(nicksinchan(exists))
                                                                                                                                                                nval = ASC(MID$(nicksinchan(exists), chkn, 1))
                                                                                                                                                                allowset = 0
                                                                                                                                                                IF isusermode(n, "ao") THEN allowset = 1
                                                                                                                                                                IF isuserchanmode(n, exists, "qaoh") THEN allowset = 1
                                                                                                                                                                IF isuserchanmode(nval, exists, "v") THEN allowset = 0
                                                                                                                                                                IF allowset = 1 AND LCASE$(arglist(argpos)) = LCASE$(nick(nval)) THEN
                                                                                                                                                                        makechanvoice exists, nval, n
                                                                                                                                                                END IF
                                                                                                                                                        NEXT chkn
                                                                                                                                                        argpos = argpos + 1
                                                                                                                                                END IF
                                                                                                                                        END IF

                                                                                                                                CASE ELSE
                                                                                                                        END SELECT
                                                                                                                END IF
                                                                                                        NEXT chkm
                                                                                                        IF deld$ <> "" THEN
                                                                                                                FOR num = 1 TO LEN(nicksinchan(exists))
                                                                                                                        curusr% = ASC(MID$(nicksinchan(exists), num, 1))
                                                                                                                        tcpSendData hands(curusr%), ":" + FullHostMask$(n) + " MODE " + chans(exists) + " :+" + deld$ + CHR$(13) + CHR$(10)
                                                                                                                NEXT num
                                                                                                        END IF

                                                                                                CASE "-" 'remove modes
                                                                                                        pre$ = "-"
                                                                                                        deld$ = ""
                                                                                                        FOR chkm = 2 TO LEN(args2$)
                                                                                                                allowset = 0
                                                                                                                IF isusermode(n, "ao") THEN allowset = 1
                                                                                                                IF isuserchanmode(n, exists, "q") THEN allowset = 1
                                                                                                                curmode$ = MID$(args2$, chkm, 1)
                                                                                                                        SELECT CASE curmode$
                                                                                                                                'CASE "C", "m", "n", "p", "s"
                                                                                                                                CASE "m", "p", "s" 'removing moderated, private, or secret
                                                                                                                                        IF isuserchanmode(n, exists, "qao") THEN allowset = 1
                                                                                                                                        IF ischanmode(exists, curmode$) THEN allowset = 1 ELSE allowset = 0
                                                                                                                                        IF exists < 1 THEN allowset = 0

                                                                                                                                        IF allowset = 1 THEN
                                                                                                                                                xpmode = INSTR(1, chanmodes(exists), curmode$)
                                                                                                                                        END IF

                                                                                                                                        IF allowset = 1 AND xpmode > 0 THEN
                                                                                                                                                chanmodes(exists) = LEFT$(chanmodes(exists), xpmode - 1) + MID$(chanmodes(exists), xpmode + 1)
                                                                                                                                                tcpSendData n, ":" + FullHostMask(n) + " MODE " + chans(exists) + " :-" + curmode$ + CHR$(13) + CHR$(10)
                                                                                                                                                FOR chkn = 1 TO LEN(nicksinchan(exists))
                                                                                                                                                        IF chkn <> n THEN tcpSendData chkn, ":" + FullHostMask(n) + " MODE " + chans(exists) + " :-" +  _
curmode$ + CHR$(13) + CHR$(10)
                                                                                                                                                NEXT chkn
                                                                                                                                        END IF

                                                                                                                                CASE "q" 'removing somebody's owner status
                                                                                                                                        IF argpos > 0 AND argpos < 4 THEN
                                                                                                                                                IF arglist(argpos) <> "" THEN
                                                                                                                                                        FOR chkn = 1 TO LEN(nicksinchan(exists))
                                                                                                                                                                nval = ASC(MID$(nicksinchan(exists), chkn, 1))
                                                                                                                                                                allowset = 0
                                                                                                                                                                IF isusermode(n, "ao") THEN allowset = 1
                                                                                                                                                                IF isuserchanmode(n, exists, "q") THEN allowset = 1
                                                                                                                                                                IF isuserchanmode(nval, exists, "q") = 0 THEN allowset = 0
                                                                                                                                                                IF allowset = 1 AND LCASE$(arglist(argpos)) = LCASE$(nick(nval)) THEN
                                                                                                                                                                        makedeowner exists, nval, n
                                                                                                                                                                END IF
                                                                                                                                                        NEXT chkn
                                                                                                                                                        argpos = argpos + 1
                                                                                                                                                END IF
                                                                                                                                        END IF

                                                                                                                                CASE "a" 'removing somebody's admin status
                                                                                                                                        IF argpos > 0 AND argpos < 4 THEN
                                                                                                                                                IF arglist(argpos) <> "" THEN
                                                                                                                                                        FOR chkn = 1 TO LEN(nicksinchan(exists))
                                                                                                                                                                nval = ASC(MID$(nicksinchan(exists), chkn, 1))
                                                                                                                                                                allowset = 0
                                                                                                                                                                IF isusermode(n, "ao") THEN allowset = 1
                                                                                                                                                                IF isuserchanmode(n, exists, "q") THEN allowset = 1
                                                                                                                                                                IF nval = n THEN allowset = 1
                                                                                                                                                                IF isuserchanmode(nval, exists, "a") = 0 THEN allowset = 0
                                                                                                                                                                IF allowset = 1 AND LCASE$(arglist(argpos)) = LCASE$(nick(nval)) THEN
                                                                                                                                                                        makedeadmin exists, nval, n
                                                                                                                                                                END IF
                                                                                                                                                        NEXT chkn
                                                                                                                                                        argpos = argpos + 1
                                                                                                                                                END IF
                                                                                                                                        END IF
                                                                                                                        
                                                                                                                                CASE "o" 'removing somebody's ops
                                                                                                                                        IF argpos > 0 AND argpos < 4 THEN
                                                                                                                                                IF arglist(argpos) <> "" THEN
                                                                                                                                                        FOR chkn = 1 TO LEN(nicksinchan(exists))
                                                                                                                                                                nval = ASC(MID$(nicksinchan(exists), chkn, 1))
                                                                                                                                                                allowset = 0
                                                                                                                                                                IF isusermode(n, "ao") THEN allowset = 1
                                                                                                                                                                IF isuserchanmode(n, exists, "qo") THEN allowset = 1
                                                                                                                                                                IF isuserchanmode(nval, exists, "o") = 0 THEN allowset = 0
                                                                                                                                                                IF allowset = 1 AND LCASE$(arglist(argpos)) = LCASE$(nick(nval)) THEN
                                                                                                                                                                        makedeop exists, nval, n
                                                                                                                                                                END IF
                                                                                                                                                        NEXT chkn
                                                                                                                                                        argpos = argpos + 1
                                                                                                                                                END IF
                                                                                                                                        END IF

                                                                                                                                CASE "h"
                                                                                                                                        IF argpos > 0 AND argpos < 4 THEN
                                                                                                                                                IF arglist(argpos) <> "" THEN
                                                                                                                                                        FOR chkn = 1 TO LEN(nicksinchan(exists))
                                                                                                                                                                nval = ASC(MID$(nicksinchan(exists), chkn, 1))
                                                                                                                                                                allowset = 0
                                                                                                                                                                IF isusermode(n, "ao") THEN allowset = 1
                                                                                                                                                                IF isuserchanmode(n, exists, "qao") THEN allowset = 1
                                                                                                                                                                IF nval = n THEN allowset = 1
                                                                                                                                                                IF isuserchanmode(nval, exists, "h") = 0 THEN allowset = 0
                                                                                                                                                                IF allowset = 1 AND LCASE$(arglist(argpos)) = LCASE$(nick(nval)) THEN
                                                                                                                                                                        IF allowset = 1 OR nval = n THEN makechandehalfop exists, nval, n
                                                                                                                                                                END IF
                                                                                                                                                        NEXT chkn
                                                                                                                                                        argpos = argpos + 1
                                                                                                                                                END IF
                                                                                                                                        END IF


                                                                                                                                CASE "v"
                                                                                                                                        IF argpos > 0 AND argpos < 4 THEN
                                                                                                                                                IF arglist(argpos) <> "" THEN
                                                                                                                                                        FOR chkn = 1 TO LEN(nicksinchan(exists))
                                                                                                                                                                nval = ASC(MID$(nicksinchan(exists), chkn, 1))
                                                                                                                                                                allowset = 0
                                                                                                                                                                IF isusermode(n, "ao") THEN allowset = 1
                                                                                                                                                                IF isuserchanmode(n, exists, "qoh") THEN allowset = 1
                                                                                                                                                                IF isuserchanmode(nval, exists, "v") = 0 THEN allowset = 0
                                                                                                                                                                IF allowset = 1 AND LCASE$(arglist(argpos)) = LCASE$(nick(nval)) THEN
                                                                                                                                                                        makedevoice exists, nval, n
                                                                                                                                                                END IF
                                                                                                                                                        NEXT chkn
                                                                                                                                                        argpos = argpos + 1
                                                                                                                                                END IF
                                                                                                                                        END IF

                                                                                                                                CASE ELSE
                                                                                                                        END SELECT
                                                                                                        NEXT chkm
                                                                                                        IF deld$ <> "" THEN
                                                                                                                FOR num = 1 TO LEN(nicksinchan(exists))
                                                                                                                        curusr% = ASC(MID$(nicksinchan(exists), num, 1))
                                                                                                                        tcpSendData hands(curusr%), ":" + FullHostMask$(n) + " MODE " + chans(exists) + " :" + pre$ + deld$ + CHR$(13) + CHR$(10)
                                                                                                                NEXT num
                                                                                                        END IF


                                                                                                CASE ELSE
                                                                                                        tcpSendData n, ":" + localdomain$ + " NOTICE " + nick(n) + " * :Invalid MODE operation request!" + CHR$(13) + CHR$(10)
                                                                                                END SELECT
                                                                        END IF
                                                                ELSE
                                                                        SendError n, 442, args$
                                                                END IF
                                                        END IF
                                                ELSE 'not a channel, but a nick
                                                        'let's check if that user is online
                                                        useronline = -1
                                                        FOR chku = 0 TO maxhand - 1
                                                                IF LCASE$(nick(chku)) = LCASE$(args$) THEN
                                                                        useronline = chku 'yes they are
                                                                END IF
                                                        NEXT chku
                                                        IF useronline = -1 THEN 'if they are not online, send error message
                                                                SendError n, 401, args$
                                                        ELSE 'alrighty.. good, they're online. let's continue.
                                                                allowchange = 0 'lets determine permission
                                                                optype$ = LEFT$(args2$, 1) 'determine if user is doing + or - of a mode
                                                                args2$ = MID$(args2$, 2)
                                                                deld$ = ""
                                                                FOR chkm = 1 TO LEN(args2$)
                                                                        curmode$ = MID$(args2$, chkm, 1)
                                                                        SELECT CASE curmode$ 'what mode are they setting?
                                                                                CASE "a" 'set server administrator
                                                                                        IF INSTR(1, usermodes(n), "a") THEN
                                                                                                'not so fast! only another
                                                                                                '+a server admin can set
                                                                                                'this special mode. let's
                                                                                                'make sure they are one!
                                                                                                allowchange = 1
                                                                                                'and YES... one +a can remove another's a
                                                                                                'so BE CAREFUL WHO YOU GIVE +a to!!!!! :)
                                                                                        END IF

                                                                                CASE "b" 'set bot flag for WHOIS info
                                                                                        IF INSTR(1, usermodes(n), "o") OR INSTR(1, usermodes(n), "a") THEN
                                                                                                'the user setting +b has to be +a server admin,
                                                                                                'or at least a +o IRC operator.
                                                                                                IF INSTR(1, usermodes(n), "o") AND INSTR(1, usermodes(useronline), "a") THEN
                                                                                                        'a +o user is NOT allowed to change a superior +a user's status
                                                                                                        allowchange = 0
                                                                                                ELSE
                                                                                                        allowchange = 1 'otherwise, allow setting change
                                                                                                END IF
                                                                                        END IF

                                                                                CASE "c" 'set connection notice flag (shows user connect/disconnects for every client)
                                                                                        IF INSTR(1, usermodes(n), "a") THEN 'has to be a +a setting it
                                                                                                allowchange = 1
                                                                                        END IF

                                                                                CASE "D" 'set debugger message flag
                                                                                        IF INSTR(1, usermodes(n), "a") THEN 'has to be a +a setting it
                                                                                                allowchange = 1
                                                                                        END IF

                                                                                CASE "h" 'set user as a +h help operator
                                                                                        IF INSTR(1, usermodes(n), "a") OR INSTR(1, usermodes(n), "o") THEN
                                                                                                'can be set by +a or +o users.
                                                                                                IF INSTR(1, usermodes(n), "o") AND INSTR(1, usermodes(useronline), "a") THEN
                                                                                                        'but if user is +o they cannot modify a superior +a's flag!
                                                                                                        allowchange = 0
                                                                                                ELSE
                                                                                                        allowchange = 1
                                                                                                END IF
                                                                                        END IF

                                                                                CASE "i" 'set user as +i, making them invisible in NAMES/WHO data
                                                                                        IF INSTR(1, usermodes(n), "a") OR INSTR(1, usermodes(n), "o") THEN
                                                                                                '+a users can modify anybody's setting at will.
                                                                                                '+o users can modify any normal user (without +a or +o)
                                                                                                'normal users (without +a or +o) may only change their own
                                                                                                IF INSTR(1, usermodes(n), "o") THEN
                                                                                                        IF INSTR(1, usermodes(useronline), "o") OR INSTR(1, usermodes(useronline), "a") THEN
                                                                                                                allowchange = 0
                                                                                                        ELSE
                                                                                                                allowchange = 1
                                                                                                        END IF
                                                                                                END IF
                                                                                                IF INSTR(1, usermodes(n), "a") THEN allowchange = 1
                                                                                                IF n = useronline THEN allowchange = 1
                                                                                        END IF

                                                                                CASE "K" 'set user as +K, causing them to get a NOTICE for every kill on the server
                                                                                        '+a users can modify anybody's setting at will.
                                                                                        '+o users can modify their own setting only.
                                                                                        'normal users can't do shit. owned.
                                                                                        IF INSTR(1, usermodes(n), "o") AND n = useronline THEN allowchange = 1
                                                                                        IF INSTR(1, usermodes(n), "a") THEN allowchange = 1

                                                                                CASE "p" 'set user as +p private, hiding channels they're in for WHOIS info
                                                                                        '+a users can modify anybody's setting at will.
                                                                                        '+o users can modify any normal user's setting, and their own.
                                                                                        'normal users can modify their own setting only.
                                                                                        IF INSTR(1, usermodes(n), "o") THEN
                                                                                                IF INSTR(1, usermodes(useronline), "a") < 1 AND INSTR(1, usermodes(useronline), "o") < 1 THEN
                                                                                                        allowchange = 1
                                                                                                END IF
                                                                                        END IF
                                                                                        IF INSTR(1, usermodes(n), "a") THEN allowchange = 1
                                                                                        IF n = useronline THEN allowchange = 1

                                                                                CASE "T" 'set user +T, blocking any CTCP message to get to them
                                                                                        '+a users can modify anybody's setting at will.
                                                                                        '+o users can modify any normal user's setting, and their own.
                                                                                        'normal users can modify their own setting only.
                                                                                        IF INSTR(1, usermodes(n), "o") THEN
                                                                                                IF INSTR(1, usermodes(useronline), "a") < 1 AND INSTR(1, usermodes(useronline), "o") < 1 THEN
                                                                                                        allowchange = 1
                                                                                                END IF
                                                                                        END IF
                                                                                        IF INSTR(1, usermodes(n), "a") THEN allowchange = 1
                                                                                        IF n = useronline THEN allowchange = 1

                                                                                CASE "w" 'set user +w, causing them to receive all wallops messages
                                                                                        'only changeable by a +a user, with one exception:
                                                                                        '+o users are allowed to change their own setting only.
                                                                                        IF INSTR(1, usermodes(n), "o") AND n = useronline THEN allowchange = 1
                                                                                        IF INSTR(1, usermodes(n), "a") THEN allowchange = 1

                                                                                CASE ELSE 'otherwise the mode they're attempting to set is invalid.
                                                                                        allowchange = 0
                                                                        END SELECT
                                                                        IF allowchange = 1 THEN 'let's do it!
                                                                                xpm = INSTR(1, usermodes(useronline), curmode$)
                                                                                IF optype$ = "-" AND xpm > 0 THEN
                                                                                        'if this is a remove mode operation, it can ONLY
                                                                                        'happen if the target user has that mode already!
                                                                                        usermodes(useronline) = LEFT$(usermodes(useronline), xpm - 1) + MID$(usermodes(useronline), xpm + 1)
                                                                                        deld$ = deld$ + curmode$
                                                                                END IF
                                                                                IF optype$ = "+" AND xpm < 1 THEN
                                                                                        'if this is an add mode operation, it can ONLY
                                                                                        'happen if the target user does not already have it!
                                                                                        usermodes(useronline) = usermodes(useronline) + curmode$
                                                                                        deld$ = deld$ + curmode$
                                                                                END IF
                                                                        END IF
                                                                NEXT chkm
                                                                IF deld$ <> "" THEN
                                                                        'only send mode change notice to users if one or more changed
                                                                        sendnote$ = ":" + FullHostMask$(n) + " MODE " + nick(useronline) + " :" + optype$ + deld$ + CHR$(13) + CHR$(10)
                                                                        IF tcpStatus(n) = sckOpen AND tcpStatus(useronline) = sckOpen THEN
                                                                                tcpSendData useronline, sendnote$
                                                                                tcpSendData n, sendnote$
                                                                        END IF
                                                                END IF
                                                        END IF
                                                END IF
                                        END IF


                                CASE "NOTICE"
                                        xp = INSTR(1, args$, " ")
                                        IF xp < 1 THEN xp = LEN(args$) + 1
                                        arg1$ = LEFT$(args$, xp - 1)
                                        arg2$ = MID$(args$, xp + 1)
                                        IF LEFT$(arg2$, 1) = ":" THEN arg2$ = MID$(arg2$, 2)
                                        IF LCASE$(arg1$) = "system" THEN
                                                ndat$ = arg2$
                                                IF LEFT$(LCASE$(arg2$), 9) = CHR$(1) + "version " AND RIGHT$(arg2$, 1) = CHR$(1) THEN
                                                        version(n) = MID$(arg2$, 10)
                                                        version(n) = LEFT$(version(n), LEN(version(n)) - 1)
                                                END IF
                                        END IF
                                        IF arg1$ = "" OR arg2$ = "" THEN
                                                IF LCASE$(arg1$) <> "system" THEN SendError n, 451, cmd$
                                        ELSE
                                                IF LEFT$(arg1$, 1) = "#" THEN
                                                        exists = ChanExist(arg1$)
                                                        novoice = 0
                                                        IF exists > 0 AND exists < 11 THEN
                                                                IF INSTR(1, chanmodes(exists), "m") > 0 AND INSTR(1, userchanmodes(n, exists), "v") < 1 THEN
                                                                        novoice = 1
                                                                END IF
                                                        END IF
                                                        IF INSTR(1, usermodes(n), "o") OR INSTR(1, usermodes(n), "a") THEN novoice = 0
                                                        IF exists = 0 OR novoice = 1 THEN
                                                                IF exists = 0 THEN
                                                                        IF LCASE$(arg1$) <> "system" THEN SendError n, 401, arg1$
                                                                ELSE
                                                                        IF LCASE$(arg1$) <> "system" THEN SendError n, 404, arg1$
                                                                END IF
                                                        ELSE
                                                                IF INSTR(1, nicksinchan(exists), CHR$(n)) = 0 THEN
                                                                        SendError n, 404, arg1$
                                                                ELSE
                                                                        broadcastmsg exists, n, arg2$
                                                                END IF
                                                        END IF
                                                ELSE
                                                        xpex = INSTR(1, arg1$, "!")
                                                        IF xpex > 0 THEN arg1$ = LEFT$(arg1$, xpex - 1)

                                                        IF LCASE$(arg1$) = "system" THEN xpex = 1: arg1$ = "" ELSE xpex = 0
                                                        IF xpex > 0 AND INSTR(1, usermodes(n), "a") THEN
                                                                'if user is trying to talk to the "system" bot, they will
                                                                'be stopped if they are not a +a server administrator.
                                                                                                   _
'tcpSendData n, ":System!Services@" + localdomain$ + " PRIVMSG " + nick(n) + " :You must be a +a server administrator to gain access to the " + CHR$(2) + "System" + CHR$(2) + " bot. Epic fail!" + CHR$(13) + CHR$(10)
                                                        ELSE
                                                                'tcpSendData n, ":System!Services@" + localdomain$ + " PRIVMSG " + nick(n) + " :Sorry, the " + CHR$(2) + "System" + CHR$(2) + " bot is not functional yet." + CHR$(13) + CHR$(10)
                                                        END IF
                                                        SELECT CASE LCASE$(arg1$)
                                                                CASE ""
                                                                CASE ELSE
                                                                        userexists = -1
                                                                        FOR chkuser = 0 TO maxhand - 1
                                                                                IF LCASE$(nick(chkuser)) = LCASE$(arg1$) THEN
                                                                                        userexists = chkuser
                                                                                        EXIT FOR
                                                                                END IF
                                                                        NEXT chkuser
                                                                        IF userexists >= 0 AND LCASE$(arg1$) <> "system" THEN
                                                                                tcpSendData userexists, ":" + FullHostMask$(n) + " NOTICE " + nick(userexists) + " :" + arg2$ + CHR$(13) + CHR$(10)
                                                                        ELSE
                                                                                SendError n, 401, arg1$
                                                                        END IF
                                                                END SELECT
                                                        END IF
                                                END IF

                                CASE "WHO"
                                        xpq = INSTR(1, args$, " ")
                                        IF xpq < 1 THEN xpq = LEN(args$) + 1
                                        namequery$ = LEFT$(args$, xpq - 1)
                                        opquery$ = LCASE$(MID$(args$, xpq + 1, 1))
                                        IF LEFT$(args$, 1) <> "#" THEN
                                                tcpSendData n, ":" + localdomain$ + " NOTICE " + nick(n) + " :Your WHO query was not for a channel, other queries are unsupported." + CHR$(13) + CHR$(10)
                                        ELSE
                                                exists = ChanExist(namequery$)
                                                IF exists > 0 THEN
                                                        FOR nuw = 1 TO LEN(nicksinchan(exists))
                                                                ccw = ASC(MID$(nicksinchan(exists), nuw, 1))
                                                                IF isusermode(ccw, "ao") > 0 THEN
                                                                        prefix$ = ""
                                                                        IF INSTR(1, userchanmodes(ccw, exists), "v") THEN prefix$ = "+ "
                                                                        IF INSTR(1, userchanmodes(ccw, exists), "h") THEN prefix$ = "% "
                                                                        IF INSTR(1, userchanmodes(ccw, exists), "o") THEN prefix$ = "@ "
                                                                        IF INSTR(1, userchanmodes(ccw, exists), "a") THEN prefix$ = "& "
                                                                        IF INSTR(1, userchanmodes(ccw, exists), "q") THEN prefix$ = "~ "
                                                                        tcpSendData n, ":" + localdomain$ + " 352 " + namequery$ + " " + userhost(ccw) + " " + vhost(ccw) + " " + localdomain$ + " " + nick(ccw) + " " + prefix$ + ":0 " + realname(ccw)  _
+ CHR$(13) + CHR$(10)
                                                                END IF
                                                        NEXT nuw
                                                END IF
                                        END IF
                                        tcpSendData n, ":" + localdomain$ + " 315 " + namequery$ + " :End of /WHO" + CHR$(13) + CHR$(10)

                                CASE "NICKSERV"
                                        arg2$ = args$
                                        GOSUB nickservmsg

                                CASE "USERS"
                                        SendError n, 466, ""

                                CASE "PRIVMSG"
                                        xp = INSTR(1, args$, " ")
                                        IF xp < 1 THEN xp = LEN(args$) + 1
                                        arg1$ = LEFT$(args$, xp - 1)
                                        arg2$ = MID$(args$, xp + 1)
                                        IF LEFT$(arg2$, 1) = ":" THEN arg2$ = MID$(arg2$, 2)
                                        xpex = INSTR(1, arg1$, "!")
                                        IF xpex > 0 THEN arg1$ = LEFT$(arg1$, xpex - 1)

                                        IF LCASE$(arg1$) = "system" THEN xpex = 1 ELSE xpex = 0
                                        IF xpex > 0 AND isusermode(n, "a") > 0 THEN
                                                'if user is trying to talk to the "system" bot, they will
                                                'be stopped if they are not a +a server administrator.
                                                    tcpSendData n, ":System!Services@" + localdomain$ + " PRIVMSG " + nick(n) + " :You must be a +a server administrator to gain access to the " + CHR$(2) + "System" + CHR$(2) + " bot. Epic fail!" +  _
CHR$(13) + CHR$(10)
                                        ELSE
                                                'tcpSendData n, ":System!Services@" + localdomain$ + " PRIVMSG " + nick(n) + " :Sorry, the " + CHR$(2) + "System" + CHR$(2) + " bot is not functional yet." + CHR$(13) + CHR$(10)
                                        END IF

                                        IF arg1$ = "" OR arg2$ = "" THEN
                                                SendError n, 451, cmd$
                                        ELSE
                                                IF LEFT$(arg1$, 1) = "#" THEN
                                                        exists = ChanExist(arg1$)
                                                        novoice = 0
                                                        IF exists > 0 AND exists < 11 THEN
                                                                IF ischanmode(exists, "m") > 0 AND isuserchanmode(n, exists, "qohv") < 1 THEN
                                                                        IF isusermode(n, "ao") = 0 THEN novoice = 1
                                                                END IF
                                                        END IF
                                                        IF exists = 0 OR novoice = 1 THEN
                                                                IF exists = 0 THEN
                                                                        IF LCASE$(arg1$) <> "system" THEN SendError n, 401, arg1$
                                                                ELSE
                                                                        IF LCASE$(arg1$) <> "system" THEN SendError n, 404, arg1$
                                                                END IF
                                                        ELSE
                                                                IF INSTR(1, nicksinchan(exists), CHR$(n)) = 0 THEN
                                                                        IF LCASE$(arg1$) <> "system" THEN
                                                                                tcpSendData n, ":ChanServ!Services@" + localdomain$ + " NOTICE " + chans(ns) +  _
" :Cannot send to channel (you are not in the channel, or you don't have +v in a +m moderated channel)" + CHR$(13) + CHR$(10)
                                                                        END IF
                                                                ELSE
                                                                        IF LCASE$(arg1$) <> "system" THEN broadcastmsg exists, n, arg2$
                                                                END IF
                                                        END IF
                                                ELSE
                                                        SELECT CASE LCASE$(arg1$)
                                                                CASE "nickserv"
                                                                        GOSUB nickservmsg
                                                                CASE ELSE
                                                                        userexists = -1
                                                                        FOR chkuser = 0 TO maxhand - 1
                                                                                IF LCASE$(nick(chkuser)) = LCASE$(arg1$) THEN
                                                                                        userexists = chkuser
                                                                                        EXIT FOR
                                                                                END IF
                                                                        NEXT chkuser
                                                                        IF userexists >= 0 THEN
                                                                                tcpSendData userexists, ":" + FullHostMask$(n) + " PRIVMSG " + nick(userexists) + " :" + arg2$ + CHR$(13) + CHR$(10)
                                                                        ELSE
                                                                                SendError n, 401, arg1$
                                                                        END IF
                                                                END SELECT
                                                        END IF
                                                END IF

                                CASE "LIST"
                                        IF args$ = "" THEN
                                                tcpSendData n, ":" + localdomain$ + " 321 " + nick(n) + " Channel :Users  Name" + CHR$(13) + CHR$(10)
                                                FOR listchans = 1 TO maxchannel%
                                                        IF chans(listchans) <> "" THEN
                                                                tcpSendData n, ":" + localdomain$ + " 322 " + nick(n) + " " + chans(listchans) + STR$(LEN(nicksinchan(listchans))) + " :" + Topic(listchans) + CHR$(13) + CHR$(10)
                                                        END IF
                                                NEXT listchans
                                                tcpSendData n, ":" + localdomain$ + " 323 " + nick(n) + " :End of /LIST" + CHR$(13) + CHR$(10)
                                        ELSE
                                                xp = INSTR(1, args$, ",")
                                                IF xp < 1 THEN xp = LEN(args$) + 1
                                                args$ = LEFT$(args$, xp - 1)
                                                xp = INSTR(1, args$, " ")
                                                IF xp < 1 THEN xp = LEN(args$) + 1
                                                args$ = LEFT$(args$, xp - 1)
                                               
                                                tempargs$ = ""
                                                FOR chkasterick = 1 TO LEN(args$)
                                                        tmpcc$ = MID$(args$, chkasterick, 1)
                                                        IF tmpcc$ <> "*" THEN tempargs$ = tempargs$ + tmpcc$
                                                NEXT chkasterick
                                               
                                                tcpSendData n, ":" + localdomain$ + " 321 " + nick(n) + " Channel :Users  Name" + CHR$(13) + CHR$(10)
                                                FOR listchans = 1 TO maxchannel%
                                                        IF INSTR(1, LCASE$(chans(listchans)), LCASE$(tempargs$)) > 0 THEN
                                                                tcpSendData n, ":" + localdomain$ + " 322 " + nick(n) + " " + chans(listchans) + STR$(LEN(nicksinchan(listchans))) + " :" + Topic(listchans) + CHR$(13) + CHR$(10)
                                                        END IF
                                                NEXT listchans
                                                tcpSendData n, ":" + localdomain$ + " 323 " + nick(n) + " :End of /LIST" + CHR$(13) + CHR$(10)

                                        END IF

                                CASE "TOPIC"
                                        xp = INSTR(1, args$, " ")
                                        IF xp < 1 THEN xp = LEN(args$) + 1
                                        arg1$ = LEFT$(args$, xp - 1)
                                        arg2$ = MID$(args$, xp + 1)
                                        IF arg1$ = "" THEN
                                                SendError n, 461, cmd$
                                        ELSE
                                                exists = ChanExist(arg1$)
                                                IF LEFT$(arg2$, 1) = ":" THEN arg2$ = MID$(arg2$, 2)
                                                IF exists > 0 THEN
                                                        IF arg2$ <> "" THEN 'setting new topic
                                                                IF INSTR(1, nicksinchan(exists), CHR$(n)) > 0 THEN
                                                                        Topic(exists) = arg2$
                                                                        topicwriter(exists) = nick(n)
                                                                        topictime(exists) = UnixTimeEnc&(DATE$, secondofday)
                                                                        FOR chku = 1 TO LEN(nicksinchan(exists))
                                                                                tmpcurusr = ASC(MID$(nicksinchan(exists), chku, 1))
                                                                                tcpSendData hands(tmpcurusr), ":" + FullHostMask$(n) + " TOPIC " + chans(exists) + " :" + arg2$ + CHR$(13) + CHR$(10)
                                                                        NEXT chku
                                                                ELSE
                                                                        SendError n, 442, arg1$
                                                                END IF
                                                        ELSE
                                                                IF Topic(exists) = "" THEN
                                                                        tcpSendData n, ":" + localdomain$ + " 331 " + nick(n) + " " + chans(exists) + " :No topic is set" + CHR$(13) + CHR$(10)
                                                                ELSE
                                                                        tcpSendData n, ":" + localdomain$ + " 332 " + nick(n) + " " + chans(exists) + " :" + Topic(exists) + CHR$(13) + CHR$(10)
                                                                        tcpSendData n, ":" + localdomain$ + " 333 " + nick(n) + " " + chans(exists) + " " + topicwriter(exists) + STR$(topictime(exists)) + CHR$(13) + CHR$(10)
                                                                END IF
                                                        END IF
                                                ELSE
                                                        SendError n, 401, cmd$
                                                END IF
                                        END IF

                                CASE "QUIT"
                                        IF args$ = "" THEN args$ = "No reason given."
                                        FOR chkchan = 1 TO maxchannel%
                                                IF INSTR(1, nicksinchan(chkchan), CHR$(n)) THEN
                                                        remfromchan chkchan, n, args$
                                                END IF
                                        NEXT chkchan
                                        tcpSendData n, "ERROR :Closing link: " + nick(n) + "[" + tcpRemoteIP$(n) + "] (" + args$ + ")" + CHR$(13) + CHR$(10)
                                        'tcpSendData n, ":" + FullHostMask$(n) + " QUIT :" + args$ + CHR$(13) + CHR$(10)
                                        tcpClose n
                                        nick(n) = ""
                                       
                                CASE ELSE
                                        SendError n, 421, fullline$
                                END SELECT
                        END IF
                END IF
                LOOP
                END IF

        'CHECK KEY INPUTS!
        key$ = INKEY$
        SELECT CASE key$
        CASE "i", "I"
                interact = 1

        CASE CHR$(27) 'exit immediately
                IF interact = 0 THEN EXIT DO ELSE interact = 0

        CASE CHR$(0) + CHR$(&H48)
                IF interact = 0 AND startview% > 0 THEN startview% = startview% - 1

        CASE CHR$(0) + CHR$(&H50)
                IF interact = 0 AND startview% < 12 THEN startview% = startview% + 1
        END SELECT

        NEXT n
       
        IF waitscreen = 10 AND interact = 0 THEN
                waitscreen = waitscreen + 1
                DrawBar
                waitscreen = 0        'draws info bar at the bottom of the screen
       
                LOCATE 2, 1, 0
                FOR disphand = startview% TO startview% + 7
                        PRINT handdesc$(disphand);
                NEXT disphand
        END IF
        IF interact = 1 THEN
                FOR nlo = 1 TO 23
                        LOCATE nlo + 1, 1, 0
                        PRINT LocalScr(nlo);
                NEXT nlo
        END IF
LOOP

FOR n = 0 TO 27
        tcpClose n
NEXT n
COLOR 7, 0: WIDTH 80: CLS
PRINT "Updating NICKSERV.INI file... ";
OPEN "CONF\NICKSERV.INI" FOR INPUT AS #1
OPEN "CONF\NICKSERV.TMP" FOR OUTPUT AS #2
DO UNTIL EOF(1)
        LINE INPUT #1, tmpline$
        IF LEFT$(tmpline$, 1) = "#" THEN PRINT #2, tmpline$
LOOP
PRINT #2, ""
count = 0
FOR n = 1 TO 50
        IF nickservdb(n, 1) <> "" THEN
                vh$ = nickservdb(n, 4)
                IF vh$ = "" THEN vh$ = "*"
                PRINT #2, nickservdb(n, 1) + ":" + nickservdb(n, 2) + ":" + nickservdb(n, 3) + ":" + vh$
                count = count + 1
        END IF
NEXT n
CLOSE #1, #2

3 DO
        wrotedata = 1
        ON ERROR GOTO 1
        KILL "CONF\NICKSERV.INI"
        NAME "CONF\NICKSERV.TMP" AS "CONF\NICKSERV.INI"
LOOP UNTIL wrotedata = 1

PRINT "OK! (" + MID$(STR$(count), 2) + " entries)"
2 PRINT

PRINT "Updating CHANSERV.INI file... ";
OPEN "CONF\CHANSERV.INI" FOR INPUT AS #1
OPEN "CONF\CHANSERV.TMP" FOR OUTPUT AS #2
DO UNTIL EOF(1)
        LINE INPUT #1, tmpline$
        IF LEFT$(tmpline$, 1) = "#" THEN PRINT #2, tmpline$
LOOP
PRINT #2, ""
PRINT "DOSIRCD has terminated successfully to DOS."
PRINT "http://www.rubbermallet.org/"
END

1 COLOR 4, 0
PRINT "FAILED!"
COLOR 7, 0
PRINT "There was a problem writing NickServ's updated database to the"
PRINT "NICKSERV.INI file. Are you out of disk space? If you are running"
PRINT "this software from a floppy disk, check to make sure that the disk's"
PRINT "write protect tab is set correctly."
PRINT
PRINT "If the NickServ database cannot be saved, any changes to it"
PRINT "including newly registered and newly unregistered nicknames"
PRINT "will be lost!"
PRINT
PRINT "Select an option, ("; : COLOR 15, 0: PRINT "R"; : COLOR 7, 0: PRINT ")etry write, or ("; : COLOR 15, 0: PRINT "C"; : COLOR 7, 0: PRINT ")ancel write? ";
LOCATE , , 1
DO: LOOP UNTIL INKEY$ = ""
DO
        SELECT CASE INKEY$
                CASE "", CHR$(0)
                CASE "r", "R"
                        PRINT "R"
                        wrotedata = 0
                        GOTO 3

                CASE "c", "C"
                        PRINT "C"
                        PRINT
                        PRINT "Changes to the NickServ database have been lost."
                        END

                CASE ELSE
                        BEEP
        END SELECT
LOOP
GOTO 2

nickservdbchecker:
IF DoNickServ = 0 THEN RETURN
FOR chknsdb = 1 TO 50
        IF LCASE$(nick(n)) = LCASE$(nickservdb(chknsdb, 1)) THEN
                'matches a nickserv db entry
                nsmatcher(n) = chknsdb
                IF nickservdb(nsmatcher(n), 2) <> "*" THEN
                        tcpSendData n, ":NickServ!Services@" + localdomain$ + " NOTICE " + nick(n) + " :This nickname is registered and protected. If it is your" + CHR$(13) + CHR$(10)
                        tcpSendData n, ":NickServ!Services@" + localdomain$ + " NOTICE " + nick(n) + " :nick, type " + CHR$(2) + "/msg NickServ IDENTIFY password" + CHR$(2) + ". Otherwise," + CHR$(13) + CHR$(10)
                        tcpSendData n, ":NickServ!Services@" + localdomain$ + " NOTICE " + nick(n) + " :If you do not change within one minute, I will change your nick." + CHR$(13) + CHR$(10)
                        nschktime!(n) = TIMER + 60
                        IF nschktime!(n) > 86400 THEN nschktime!(n) = nschktime!(n) - 86400

                        IF INSTR(1, usermodes(n), "u") < 1 THEN
                                usermodes(n) = usermodes(n) + "u"
                                ShowUserModes n
                        END IF
                END IF
        END IF
NEXT chknsdb
RETURN


nickservmsg:
xpns = INSTR(1, arg2$, " ")
IF xpns < 1 THEN xpns = LEN(arg2$) + 1
nscmd$ = LEFT$(arg2$, xpns - 1)
nsarg$ = MID$(arg2$, xpns + 1)
'xpns2 = INSTR(1, nsarg$, " ")
'IF xpns2 < 1 THEN xpns2 = LEN(nsarg$) + 1
'nsarg2$ = MID$(nsarg$, xpns2 + 1)
'nsarg$ = LEFT$(nsarg$, xpns2 - 1)

SELECT CASE LCASE$(nscmd$)
        CASE ""

        CASE "newpass"
                IF INSTR(1, usermodes(n), "u") < 1 THEN
                        truenick$ = nickservdb(nsmatcher(n), 1)
                        nickservdb(nsmatcher(n), 1) = ""
                        nickservdb(nsmatcher(n), 2) = ""
                        nickservdb(nsmatcher(n), 3) = ""
                        nickservdb(nsmatcher(n), 4) = ""
                        nsmatcher(n) = 0
                        tcpSendData n, ":NickServ!Services@" + localdomain$ + " NOTICE " + nick(n) + " :Your NickServ password has been changed to " + CHR$(2) + nsarg$ + CHR$(2) + "." + CHR$(13) + CHR$(10)
                        tcpSendData n, ":NickServ!Services@" + localdomain$ + " NOTICE " + nick(n) + " :Please note that this nickname will now be available to anybody else to register!" + CHR$(13) + CHR$(10)
                ELSE
                        tcpSendData n, ":NickServ!Services@" + localdomain$ + " NOTICE " + nick(n) + " :Sorry, you " + CHR$(2) + "must" + CHR$(2) + " identify with your old password before you can change it!" + CHR$(13) + CHR$(10)
                END IF


        CASE "identify"
                IF nsmatcher(n) > 0 AND nsmatcher(n) < 51 THEN
                IF LCASE$(nick(n)) = LCASE$(nickservdb(nsmatcher(n), 1)) THEN
                        IF INSTR(1, usermodes(n), "u") THEN
                                IF nsarg$ = nickservdb(nsmatcher(n), 2) THEN
                                        verified(n) = 1
                                        tcpSendData n, ":NickServ!Services@" + localdomain$ + " NOTICE " + nick(n) + " :Password accepted! You are now recognized." + CHR$(13) + CHR$(10)
                                        remusermode n, "u"
                                        DoModeAdd n, userlevels(VAL(nickservdb(nsmatcher(n), 3)))
                                ELSE
                                        tcpSendData n, ":NickServ!Services@" + localdomain$ + " NOTICE " + nick(n) + " :Password incorrect." + CHR$(13) + CHR$(10)
                                END IF
                        ELSE
                                tcpSendData n, ":NickServ!Services@" + localdomain$ + " NOTICE " + nick(n) + " :You have already identified with NickServ, and are recognized." + CHR$(13) + CHR$(10)
                        END IF
                ELSE
                        tcpSendData n, ":NickServ!Services@" + localdomain$ + " NOTICE " + nick(n) + " :Your nickname is not registered." + CHR$(13) + CHR$(10)
                        tcpSendData n, ":NickServ!Services@" + localdomain$ + " NOTICE " + nick(n) + " :Unknown command " + CHR$(2) + nsarg$ + CHR$(2) + ". " + CHR$(34) + "/msg NickServ HELP" + CHR$(34) + " for help." + CHR$(13) + CHR$(10)
                END IF
                END IF

        CASE "register"
                xpr = INSTR(1, nsarg$, " ")
                IF xpr > 0 THEN nsarg$ = LEFT$(nsarg$, xpr - 1)
                IF nsarg$ = "" THEN
                        tcpSendData n, ":NickServ!Services@" + localdomain$ + " NOTICE " + nick(n) + " :You " + CHR$(2) + "must" + CHR$(2) + " provide a password to register!" + CHR$(13) + CHR$(10)
                ELSE
                        blankentry = 0
                        FOR chke = 1 TO 50
                                IF nickservdb(chke, 1) = "" THEN
                                        blankentry = chke
                                        EXIT FOR
                                END IF
                        NEXT chke
                        IF blankentry = 0 THEN
                                tcpSendData n, ":NickServ!Services@" + localdomain$ + " NOTICE " + nick(n) + " :Sorry, the NickServ database is full and cannot accept any more entries!" + CHR$(13) + CHR$(10)
                        ELSE
                                nickservdb(blankentry, 1) = nick(n)
                                nickservdb(blankentry, 2) = nsarg$
                                nickservdb(blankentry, 3) = MID$(STR$(newreglevel%), 2)
                                nickservdb(blankentry, 4) = "*"
                                nsmatcher(n) = blankentry
                                tcpSendData n, ":NickServ!Services@" + localdomain$ + " NOTICE " + nick(n) + " :Your nickname " + CHR$(2) + nick(n) + CHR$(2) + " is now registered and protected." + CHR$(13) + CHR$(10)
                                tcpSendData n, ":NickServ!Services@" + localdomain$ + " NOTICE " + nick(n) + " :The password you supplied is " + CHR$(2) + nsarg$ + CHR$(2) + " - please write this down. It is case sensitive!" + CHR$(13) + CHR$(10)
                                remusermode n, "u"
                                DoModeAdd n, userlevels(VAL(nickservdb(nsmatcher(n), 3)))
                        END IF
                END IF

        CASE "drop"
                IF INSTR(1, usermodes(n), "u") < 1 THEN
                        truenick$ = nickservdb(nsmatcher(n), 1)
                        nickservdb(nsmatcher(n), 1) = ""
                        nickservdb(nsmatcher(n), 2) = ""
                        nickservdb(nsmatcher(n), 3) = ""
                        nickservdb(nsmatcher(n), 4) = ""
                        nsmatcher(n) = 0
                        tcpSendData n, ":NickServ!Services@" + localdomain$ + " NOTICE " + nick(n) + " :Your registered nickname " + CHR$(2) + truenick$ + CHR$(2) + " has been removed from the NickServ database." + CHR$(13) + CHR$(10)
                        tcpSendData n, ":NickServ!Services@" + localdomain$ + " NOTICE " + nick(n) + " :Please note that this nickname will now be available to anybody else to register!" + CHR$(13) + CHR$(10)
                ELSE
                        tcpSendData n, ":NickServ!Services@" + localdomain$ + " NOTICE " + nick(n) + " :Sorry, you " + CHR$(2) + "must" + CHR$(2) + " identify before you can " + CHR$(2) + "drop" + CHR$(2) + " it!" + CHR$(13) + CHR$(10)
                END IF

        CASE "ghost"
                IF nsarg$ = "" THEN
                        tcpSendData n, ":NickServ!Services@" + localdomain$ + " NOTICE " + nick(n) + " :You " + CHR$(2) + "must" + CHR$(2) + " provide both your registered nickname and password to ghost!" + CHR$(13) + CHR$(10)
                        RETURN
                END IF
                xpg = INSTR(1, nsarg$, " ")
                IF xpg < 1 THEN
                        tcpSendData n, ":NickServ!Services@" + localdomain$ + " NOTICE " + nick(n) + " :You " + CHR$(2) + "must" + CHR$(2) + " provide both your registered nickname and password to ghost!" + CHR$(13) + CHR$(10)
                        RETURN
                END IF
                nsarg2$ = MID$(nsarg$, xpg + 1)
                nsarg$ = LEFT$(nsarg$, xpg - 1)
                xpg = INSTR(1, nsarg2$, " ")
                IF xpg > 0 THEN nsarg2$ = LEFT$(nsarg2$, xpg - 1)
                founddb = -1
                FOR chkg = 1 TO 50
                        IF LCASE$(nsarg$) = LCASE$(nickservdb(chkg, 1)) THEN
                                founddb = chkg
                                EXIT FOR
                        END IF
                NEXT chkg
                IF founddb = -1 THEN
                        tcpSendData n, ":NickServ!Services@" + localdomain$ + " NOTICE " + nick(n) + " :Sorry, the nickname you provided is not registered with NickServ!" + CHR$(13) + CHR$(10)
                        RETURN
                END IF
                found = -1
                FOR chkg = 0 TO maxhand - 1
                        IF LCASE$(nick(chkg)) = LCASE$(nsarg$) THEN
                                found = chkg
                                EXIT FOR
                        END IF
                NEXT chkg
                IF found = -1 THEN
                        tcpSendData n, ":NickServ!Services@" + localdomain$ + " NOTICE " + nick(n) + " :Sorry, there is no client currently using the nickname you provided!" + CHR$(13) + CHR$(10)
                        RETURN
                END IF
                IF nsarg2$ <> nickservdb(founddb, 2) THEN
                        tcpSendData n, ":NickServ!Services@" + localdomain$ + " NOTICE " + nick(n) + " :Sorry, the password you provided is not correct!" + CHR$(13) + CHR$(10)
                        RETURN
                ELSE
                        KillClient found, "Ghost kill given by " + nick(n), "NickServ!Services@" + localdomain$
                        tcpSendData n, ":NickServ!Services@" + localdomain$ + " NOTICE " + nick(n) + " :Ghost with your nick has been killed!" + CHR$(13) + CHR$(10)
                END IF

        CASE "help"
                IF nsarg$ = "" THEN nsarg$ = "main"
                        temphelp$ = ""
                        nshl = INSTR(1, NickServHelp, "%" + LCASE$(nsarg$))
                        IF nshl > 0 THEN
                                tmphelp$ = MID$(NickServHelp, nshl + LEN(nsarg$) + 1)
                                nshe = INSTR(1, tmphelp$, "%")
                                IF nshe < 1 THEN nshe = LEN(tmphelp$) + 1
                                tmphelp$ = LEFT$(tmphelp$, nshe - 1)
                                DO UNTIL tmphelp$ = ""
                                        xplol = INSTR(1, tmphelp$, CHR$(13))
                                        IF xplol > 0 THEN
                                                OutBuffer n, ":NickServ!Services@" + localdomain$ + " NOTICE " + nick(n) + " :" + LEFT$(tmphelp$, xplol - 1) + CHR$(13) + CHR$(10)
                                                tmphelp$ = MID$(tmphelp$, xplol + 1)
                                        END IF
                                        tcpSendData n, SendBuffer(n)
                                        SendBuffer(n) = ""
                                LOOP
                        ELSE
                                tcpSendData n, ":NickServ!Services@" + localdomain$ + " NOTICE " + nick(n) + " :No help available for command " + CHR$(2) + nsarg$ + CHR$(2) + "." + CHR$(13) + CHR$(10)
                        END IF
        CASE ELSE
                tcpSendData n, ":NickServ!Services@" + localdomain$ + " NOTICE " + nick(n) + " :Unknown command " + CHR$(2) + nsarg$ + CHR$(2) + ". " + CHR$(34) + "/msg NickServ HELP" + CHR$(34) + " for help." + CHR$(13) + CHR$(10)
END SELECT
RETURN

switchnick:
oldnick$ = nick(n)
nick(n) = testednick$

IF INSTR(1, usermodes(n), "u") THEN remusermode n, "u"

tcpSendData n, ":" + oldnick$ + " NICK " + testednick$ + CHR$(13) + CHR$(10)
told$ = CHR$(n)
FOR ch = 1 TO maxchannel%
        IF chans(ch) <> "" AND INSTR(1, nicksinchan(ch), CHR$(n)) > 0 THEN
                FOR chu = 1 TO LEN(nicksinchan(ch))
                        IF INSTR(1, told$, MID$(nicksinchan(ch), chu, 1)) < 1 THEN
                                tcpSendData ASC(MID$(nicksinchan(ch), chu, 1)), ":" + oldnick$ + " NICK " + testednick$ + CHR$(13) + CHR$(10)
                                told$ = told$ + MID$(nicksinchan(ch), chu, 1)
                        END IF
                NEXT chu
        END IF
NEXT ch
RETURN


loginsequence:
vhost(n) = tcpRemoteIP(n)
OutBuffer n, ":" + localdomain$ + " 001 " + nick(n) + " :Welcome to the IRC server at " + localdomain$ + " " + FullHostMask(n) + CHR$(13) + CHR$(10)
OutBuffer n, ":" + localdomain$ + " 002 " + nick(n) + " :Your host is " + localdomain$ + ", running DOSIRCD version 1.0" + CHR$(13) + CHR$(10)
OutBuffer n, ":" + localdomain$ + " 003 " + nick(n) + " :This server has been online since " + startdate$ + " at " + starttime$ + CHR$(13) + CHR$(10)
OutBuffer n, ":" + localdomain$ + " 004 " + nick(n) + " " + network$ + " DOSIRCD1.0" + CHR$(13) + CHR$(10)
OutBuffer n, ":" + localdomain$ + " 005 " + nick(n) + " MAXCHANNEL=" + MID$(STR$(maxchannel%), 2) + " NICKLEN=" + MID$(STR$(nicklen%), 2) + " TOPICLEN=" + MID$(STR$(topiclen%), 2) + " :are supported by this server" + CHR$(13) + CHR$(10)
OutBuffer n, ":" + localdomain$ + " 005 " + nick(n) + " CHANTYPES=# PREFIX=(qaohv)~&@%+ CHANMODES=Cmnps NETWORK=" + network$ + " CASEMAPPING=ascii :are supported by this server" + CHR$(13) + CHR$(10)
OutBuffer n, ":" + localdomain$ + " 251 " + nick(n) + " :There are" + STR$(onlinecount) + " users and 0 invisible on 1 server" + CHR$(13) + CHR$(10)
OutBuffer n, ":" + localdomain$ + " 252 " + nick(n) + " 0 :operator(s) online" + CHR$(13) + CHR$(10)
OutBuffer n, ":" + localdomain$ + " 254 " + nick(n) + STR$(chancount%) + " :channel(s) formed" + CHR$(13) + CHR$(10)
OutBuffer n, ":" + localdomain$ + " 255 " + nick(n) + " :I have" + STR$(onlinecount) + " client(s) and 1 server(s)" + CHR$(13) + CHR$(10)
OutBuffer n, ":" + localdomain$ + " 265 " + nick(n) + " :Current Local Users:" + STR$(onlinecount) + "  Max:" + STR$(maxhand) + CHR$(13) + CHR$(10)
tcpSendData n, SendBuffer(n): SendBuffer(n) = ""
tcpSendData n, ":System!Services@" + localdomain$ + " PRIVMSG " + nick(n) + " :" + CHR$(1) + "VERSION" + CHR$(1) + CHR$(13) + CHR$(10)

IF motd = "" THEN
        tcpSendData n, ":" + localdomain$ + " 422 " + nick(n) + " :MOTD File is missing" + CHR$(13) + CHR$(10)
ELSE
        tcpSendData n, ":" + localdomain$ + " 375 " + nick(n) + " :- " + localdomain$ + " Message of the Day -" + CHR$(13) + CHR$(10)
        tmpmotd$ = motd
        DO UNTIL tmpmotd$ = ""
                xpm = INSTR(1, tmpmotd$, CHR$(13))
                IF xpm < 1 THEN xpm = LEN(tmpmotd$) + 1
                tcpSendData n, ":" + localdomain$ + " 372 " + nick(n) + " :- " + LEFT$(tmpmotd$, xpm - 1) + CHR$(13) + CHR$(10)
                tmpmotd$ = MID$(tmpmotd$, xpm + 1)
                IF LEFT$(tmpmotd$, 1) = CHR$(10) THEN tmpmotd$ = MID$(tmpmotd$, 2)
        LOOP
        tcpSendData n, ":" + localdomain$ + " 376 " + nick(n) + " :End of /MOTD command." + CHR$(13) + CHR$(10)
END IF

usermodes(n) = ""
DoModeAdd n, userlevels(0)

GOSUB nickservdbchecker
RETURN

FUNCTION addchanban% (chn%, banhost$)
addchanban% = 0
IF bancount(chn%) = 20 THEN EXIT FUNCTION
banlist(chn%, bancount(chn%) + 1) = banhost$
'AddLog "added ban to " + chans(chn%) + " for " + banhost$
addchanban% = 1
END FUNCTION

SUB AddLog (Text AS STRING)
FOR numb = 2 TO 14
        LogBuffer(numb - 1) = LEFT$(LogBuffer(numb) + SPACE$(80), 80)
NEXT numb
LogBuffer(14) = LEFT$(Text + SPACE$(80), 80)

IF interact = 0 THEN
LOCATE 11, 1, 0
FOR numb = 1 TO 14
        PRINT LogBuffer(numb);
NEXT numb
END IF
END SUB

DEFSNG A-Z
SUB addtochan (whichchan%, whichuser AS INTEGER)
IF ischanbanned(whichchan%, whichuser) = 1 THEN
        IF isusermode(whichuser, "ao") > 0 THEN
                tcpSendData hands(whichuser), ":" + localdomain$ + " NOTICE " + nick(whichuser) + " :You match a hostmask in the banlist of " + CHR$(2) + chans(whichchan%) + CHR$(2) +  _
", however you are a server administrator or IRC operator. You are being let in anyway." + CHR$(13) + CHR$(10)
        ELSE
                tcpSendData hands(whichuser), ":" + localdomain$ + " 474 " + chans(whichchan%) + " :Cannot join channel (+b)" + CHR$(13) + CHR$(10)
                EXIT SUB
        END IF
END IF

xpw = INSTR(1, nicksinchan(whichchan%), CHR$(whichuser))
IF xpw < 1 THEN nicksinchan(whichchan%) = nicksinchan(whichchan%) + CHR$(whichuser)

IF INSTR(1, chanmodes(whichchan%), "n") < 1 THEN chanmodes(whichchan%) = chanmodes(whichchan%) + "n"

IF nicksinchan(whichchan%) = CHR$(whichuser) OR INSTR(1, usermodes(whichuser), "a") OR INSTR(1, usermodes(whichuser), "o") THEN
        userchanmodes(whichuser, whichchan%) = userchanmodes(whichuser, whichchan%) + "q"
END IF

FOR nt = 1 TO LEN(nicksinchan(whichchan%))
        tcpSendData hands(ASC(MID$(nicksinchan(whichchan%), nt, 1))), ":" + FullHostMask(whichuser) + " JOIN " + chans(whichchan%) + CHR$(13) + CHR$(10)
        IF userchanmodes(whichuser, whichchan%) <> "" THEN
                tcpSendData hands(ASC(MID$(nicksinchan(whichchan%), nt, 1))), ":ChanServ!Services@" + localdomain$ + " MODE " + chans(whichchan%) + " :+" + userchanmodes(whichuser, whichchan%) + " " + nick(whichuser) + CHR$(13) + CHR$(10)
        END IF
NEXT nt

tcpSendData whichuser, ":" + localdomain$ + " 353 " + nick(n) + " = " + chans(whichchan%) + " :" + userlist(whichchan%) + CHR$(13) + CHR$(10)
tcpSendData whichuser, ":" + localdomain$ + " 366 " + nick(n) + " " + chans(whichchan%) + " :End of /NAMES list" + CHR$(13) + CHR$(10)

IF Topic(whichchan%) = "" THEN
        tcpSendData whichuser, ":" + localdomain$ + " 331 " + nick(n) + " " + chans(whichchan%) + " :No topic is set" + CHR$(13) + CHR$(10)
ELSE
        tcpSendData whichuser, ":" + localdomain$ + " 332 " + nick(n) + " " + chans(whichchan%) + " :" + Topic(whichchan%) + CHR$(13) + CHR$(10)
        tcpSendData whichuser, ":" + localdomain$ + " 333 " + nick(n) + " " + chans(whichchan%) + " " + topicwriter(whichchan%) + STR$(topictime(whichchan%)) + CHR$(13) + CHR$(10)
END IF
END SUB

SUB broadcastmsg (tochan%, fromnick%, msgtext$)
SELECT CASE LCASE$(chans(tochan%))
        CASE "#wtfpwnt", "#dxm", "#test"
                tm$ = chans(tochan%) + " <" + nick(fromnick%) + "> " + msgtext$
                DO UNTIL tm$ = ""
                        FOR nlo = 2 TO 23
                                LocalScr(nlo - 1) = LocalScr(nlo)
                        NEXT nlo
                        LocalScr(23) = LEFT$(tm$ + SPACE$(80), 80)
                        tm$ = MID$(tm$, 81)
                LOOP
END SELECT

FOR num = 1 TO LEN(nicksinchan(tochan%))
        curusr% = ASC(MID$(nicksinchan(tochan%), num, 1))
        IF curusr% <> fromnick% THEN
                tcpSendData hands(curusr%), ":" + nick(fromnick%) + " PRIVMSG " + chans(tochan%) + " :" + msgtext$ + CHR$(13) + CHR$(10)
        END IF
NEXT num
END SUB

DEFINT A-Z
FUNCTION chancount%
chancount% = 0
tempcount% = 0
FOR tempstuff% = 1 TO maxchannel%
        IF chans(tempstuff%) <> "" THEN tempcount% = tempcount% + 1
NEXT tempstuff%
chancount% = tempcount%
END FUNCTION

FUNCTION ChanExist% (checkname$)
ChanExist% = 0
FOR chkchan% = 1 TO maxchannel%
        IF LCASE$(chans(chkchan%)) = LCASE$(checkname$) THEN
                ChanExist% = chkchan%
                EXIT FUNCTION
        END IF
NEXT chkchan%
END FUNCTION

FUNCTION CheckAdminUsername% (ou$)
CheckAdminUsername% = 0
OPEN "WEBPANEL\ACCESS.DAT" FOR BINARY AS #1: asz = LOF(1): CLOSE #1
IF asz < 1 THEN EXIT FUNCTION
OPEN "WEBPANEL\ACCESS.DAT" FOR INPUT AS #1
DO UNTIL EOF(1)
        LINE INPUT #1, tmpun$ 'username
        IF EOF(1) THEN EXIT DO
        LINE INPUT #1, tmppw$ 'password
        IF EOF(1) THEN EXIT DO
        LINE INPUT #1, tmprn$ 'real name
        IF EOF(1) THEN EXIT DO
        LINE INPUT #1, tmppm$ 'permission level
        IF LCASE$(tmpn$) = LCASE$(ou$) THEN CheckAdminUsername% = 1: EXIT DO

LOOP
CLOSE #1
END FUNCTION

DEFSNG A-Z
FUNCTION Conv2DWord$ (inString AS STRING)
'The inString variable should be an IPv4 address in the standard
'format of x.x.x.x

DIM tempArray(3) AS STRING * 1
DIM tempVal AS INTEGER

tempVal = INSTR(1, inString, ".")
IF tempVal THEN
        tempArray(0) = CHR$(VAL(LEFT$(inString, tempVal)))
        inString = MID$(inString, tempVal + 1)
ELSE
        EXIT FUNCTION
END IF

tempVal = INSTR(1, inString, ".")
IF tempVal THEN
        tempArray(1) = CHR$(VAL(LEFT$(inString, tempVal)))
        inString = MID$(inString, tempVal + 1)
ELSE
        EXIT FUNCTION
END IF

tempVal = INSTR(1, inString, ".")
IF tempVal THEN
        tempArray(2) = CHR$(VAL(LEFT$(inString, tempVal)))
        inString = MID$(inString, tempVal + 1)
ELSE
        EXIT FUNCTION
END IF

tempArray(3) = CHR$(VAL(inString))
Conv2DWord$ = tempArray(0) + tempArray(1) + tempArray(2) + tempArray(3)
END FUNCTION

FUNCTION Conv2IP$ (DWord AS LONG)
DIM tempstr AS STRING * 4

tempstr = MKL$(DWord)

Conv2IP$ = MID$(STR$(ASC(LEFT$(tempstr, 1))), 2) + "." + MID$(STR$(ASC(MID$(tempstr, 2, 1))), 2) + "." + MID$(STR$(ASC(MID$(tempstr, 3, 1))), 2) + "." + MID$(STR$(ASC(RIGHT$(tempstr, 1))), 2)
END FUNCTION

DEFINT A-Z
FUNCTION ConvFromForm$ (inputdata$)
tmpdata$ = ""
FOR nu = 1 TO LEN(inputdata$)
        cc$ = MID$(inputdata$, nu, 1)
        SELECT CASE cc$
        CASE "+"
                cc$ = " "
        END SELECT
        tmpdata$ = tmpdata$ + cc$
NEXT nu
ConvFromForm$ = tmpdata$
END FUNCTION

FUNCTION createchan%
FOR chkchan% = 1 TO maxchannel%
        IF chans(chkchan%) = "" THEN
                createchan% = chkchan%
                EXIT FUNCTION
        END IF
NEXT chkchan%
END FUNCTION

SUB DoModeAdd (handval%, newmodes$)
deld$ = ""
FOR chkem = 1 TO LEN(newmodes$)
        chksingle$ = MID$(newmodes$, chkem, 1)
        xp = INSTR(1, usermodes(handval%), chksingle$)
        IF xp < 1 THEN
                usermodes(handval%) = usermodes(handval%) + chksingle$
                deld$ = deld$ + chksingle$
        END IF
NEXT chkem
IF deld$ <> "" THEN
        tcpSendData handval%, ":" + localdomain$ + " MODE " + nick(handval%) + " :+" + deld$ + CHR$(13) + CHR$(10)
END IF


IF INSTR(1, usermodes(handval%), "v") < 1 THEN 'if client is not set to have a real vhost
        IF INSTR(1, usermodes(handval%), "x") THEN 'then if they are +x, mask their IP
                vhost(handval%) = Masker(tcpRemoteIP(handval%))
        ELSE 'or if they are not +x, use their real IP address in the hostmask!
                vhost(handval%) = tcpRemoteIP(handval%)
        END IF
END IF
END SUB

SUB DoNewPing (whichhand%, t!)
testval! = t! + pingtimeout!
IF testval! > 86360 OR TIMER < 60 THEN
        waituntil!(whichhand%) = 60
        lastping!(whichhand%) = 0
        nextping!(whichhand%) = 60
        gotpingresponse!(whichhand%) = 1
ELSE
        tcpSendData whichhand%, "PING :" + MID$(STR$(t!), 2) + CHR$(13) + CHR$(10)
        lastping!(whichhand%) = t!
        nextping!(whichhand%) = t! + pinginterval!
        waituntil!(whichhand%) = t! + pingtimeout!
        gotpingresponse!(whichhand%) = 0
END IF
END SUB

SUB DrawBar
COLOR 0, 7
temp1$ = STR$(onlinecount) + " users currently online"
temp2$ = DATE$ + " " + TIME$ + " "
texttemp$ = temp1$ + SPACE$(80 - (LEN(temp1$) + LEN(temp2$))) + temp2$
LOCATE 25, 1
PRINT texttemp$;
COLOR 7, 0
END SUB

FUNCTION FullHostMask$ (hvalue%)
IF isregistered(hvalue%) = 0 THEN FullHostMask$ = "": EXIT FUNCTION

FullHostMask$ = nick(hvalue%) + "!" + userhost(hvalue%) + "@" + vhost(hvalue%)
END FUNCTION

DEFSNG A-Z
FUNCTION HighByte% (Word AS INTEGER)
HighByte% = ASC(RIGHT$(MKI$(Word), 1))
END FUNCTION

DEFINT A-Z
FUNCTION ischanbanned% (chn%, chknick%)
ischanbanned% = 0
FOR nuy = 1 TO bancount(chn%)
        FOR nuy2 = 1 TO LEN(nicksinchan(chn%))
                IF matchban(nuy2, banlist(chn%, nuy)) = 1 THEN
                        ischanbanned% = 1
                        EXIT FUNCTION
                END IF
        NEXT nuy2
NEXT nuy
END FUNCTION

FUNCTION ischanmode% (chanval%, modeval$)
ischanmode% = 0

FOR nuchk = 1 TO LEN(modeval$)
        IF INSTR(1, chanmodes(chanval%), MID$(modeval$, nuchk, 1)) > 0 THEN ischanmode% = 1
NEXT nuchk
END FUNCTION

FUNCTION isuserchanmode% (nickval%, chanval%, modeval$)
isuserchanmode% = 0

FOR nuchk = 1 TO LEN(modeval$)
        IF INSTR(1, userchanmodes(nickval%, chanval%), MID$(modeval$, nuchk, 1)) > 0 THEN isuserchanmode% = 1
NEXT nuchk
END FUNCTION

FUNCTION isusermode% (nickval%, modeval$)
isusermode% = 0

FOR nuchk = 1 TO LEN(modeval$)
        IF INSTR(1, usermodes(nickval%), MID$(modeval$, nuchk, 1)) > 0 THEN isusermode% = 1
NEXT nuchk
END FUNCTION

SUB killchannel (whichchan%)
chans(whichchan%) = ""
nicksinchan(whichchan%) = ""
Topic(whichchan%) = ""
topicwriter(whichchan%) = ""
chanmodes(whichchan%) = ""
FOR chku% = 0 TO 19
        userchanmodes(chku%, whichchan%) = ""
NEXT chku%
END SUB

SUB KillClient (killwho%, reason$, killer$)
tcpSendData killwho%, ":" + killer$ + " KILL " + nick(killwho%) + " :" + killer$ + " (" + reason$ + ")" + CHR$(13) + CHR$(10)
tcpSendData killwho%, "ERROR :Closing link " + nick(killwho%) + "[" + tcpRemoteIP(killwho%) + "] " + killer$ + " " + reason$ + CHR$(13) + CHR$(10)
tcpClose killwho%
FOR chkk = 1 TO maxchannel%
        xpk = INSTR(1, nicksinchan(chkk), CHR$(killwho%))
        IF xpk > 0 AND chans(chkk) <> "" THEN
                FOR chkk2 = 1 TO LEN(nicksinchan(chkk))
                        tmphan% = hands(ASC(MID$(nicksinchan(chkk%), chkk2, 1)))
                        IF tmphan% <> killwho% THEN tcpSendData tmphan%, ":" + nick(killwho%) + " QUIT :" + reason$ + CHR$(13) + CHR$(10)
                NEXT chkk2
        END IF
NEXT chkk
END SUB

DEFSNG A-Z
FUNCTION LowByte% (Word AS INTEGER)
LowByte% = ASC(LEFT$(MKI$(Word), 1))
END FUNCTION

DEFINT A-Z
SUB makechanadmin (cval%, nval%, fval%)
'channel, nick to op, who requested it

IF isuserchanmode(nval%, cval%, "a") = 0 THEN 'see if they are +a
        'if they aren't, give it to them
        userchanmodes(nval%, cval%) = userchanmodes(nval%, cval%) + "a"
        FOR chks = 1 TO LEN(nicksinchan(cval%))
                chks2 = ASC(MID$(nicksinchan(cval%), chks, 1))
                tcpSendData chks2, ":" + FullHostMask(fval%) + " MODE " + chans(cval%) + " :+a " + nick(nval%) + CHR$(13) + CHR$(10)
        NEXT chks
END IF
END SUB

SUB makechandehalfop (cval%, nval%, fval%)
'channel, nick to op, who requested it

IF isuserchanmode(nval%, cval%, "h") = 1 THEN 'see if they are +h
        'if they are, take it from them
        xphp = INSTR(1, userchanmodes(nval%, cval%), "h")
        IF xphp > 0 THEN
                userchanmodes(nval%, cval%) = LEFT$(userchanmodes(nval%, cval%), xphp - 1) + MID$(userchanmodes(nval%, cval%), xphp + 1)
                FOR chks = 1 TO LEN(nicksinchan(cval%))
                        chks2 = ASC(MID$(nicksinchan(cval%), chks, 1))
                        tcpSendData chks2, ":" + FullHostMask(fval%) + " MODE " + chans(cval%) + " :-h " + nick(nval%) + CHR$(13) + CHR$(10)
                NEXT chks
        END IF
END IF
END SUB

SUB makechanhalfop (cval%, nval%, fval%)
'channel, nick to op, who requested it

IF isuserchanmode(nval%, cval%, "h") = 0 THEN 'see if they are +h
        'if they aren't, give it to them
        userchanmodes(nval%, cval%) = userchanmodes(nval%, cval%) + "h"
        FOR chks = 1 TO LEN(nicksinchan(cval%))
                chks2 = ASC(MID$(nicksinchan(cval%), chks, 1))
                tcpSendData chks2, ":" + FullHostMask(fval%) + " MODE " + chans(cval%) + " :+h " + nick(nval%) + CHR$(13) + CHR$(10)
        NEXT chks
END IF
END SUB

SUB makechanop (cval%, nval%, fval%)
'channel, nick to op, who requested it

IF isuserchanmode(nval%, cval%, "o") = 0 THEN 'see if they are +o
        'if they aren't, give it to them
        userchanmodes(nval%, cval%) = userchanmodes(nval%, cval%) + "o"
        FOR chks = 1 TO LEN(nicksinchan(cval%))
                chks2 = ASC(MID$(nicksinchan(cval%), chks, 1))
                tcpSendData chks2, ":" + FullHostMask(fval%) + " MODE " + chans(cval%) + " :+o " + nick(nval%) + CHR$(13) + CHR$(10)
        NEXT chks
END IF
END SUB

SUB makechanowner (cval%, nval%, fval%)
'channel, nick to op, who requested it

IF isuserchanmode(nval%, cval%, "q") = 0 THEN 'see if they are +q
        'if they aren't, give it to them
        userchanmodes(nval%, cval%) = userchanmodes(nval%, cval%) + "q"
        FOR chks = 1 TO LEN(nicksinchan(cval%))
                chks2 = ASC(MID$(nicksinchan(cval%), chks, 1))
                tcpSendData chks2, ":" + FullHostMask(fval%) + " MODE " + chans(cval%) + " :+q " + nick(nval%) + CHR$(13) + CHR$(10)
        NEXT chks
END IF
END SUB

SUB makechanvoice (cval%, nval%, fval%)
'channel, nick to op, who requested it

IF isuserchanmode(nval%, cval%, "v") = 0 THEN 'see if they are +v
        'if they aren't, give it to them
        userchanmodes(nval%, cval%) = userchanmodes(nval%, cval%) + "v"
        FOR chks = 1 TO LEN(nicksinchan(cval%))
                chks2 = ASC(MID$(nicksinchan(cval%), chks, 1))
                tcpSendData chks2, ":" + FullHostMask(fval%) + " MODE " + chans(cval%) + " :+v " + nick(nval%) + CHR$(13) + CHR$(10)
        NEXT chks
END IF
END SUB

SUB makedeadmin (cval%, nval%, fval%)
'channel, nick to deowner, who requested it

xpd = INSTR(1, userchanmodes(nval%, cval%), "a")

IF xpd > 0 THEN
        userchanmodes(nval%, cval%) = LEFT$(userchanmodes(nval%, cval%), xpd - 1) + MID$(userchanmodes(nval%, cval%), xpd + 1)
        FOR chks = 1 TO LEN(nicksinchan(cval%))
                chks2 = ASC(MID$(nicksinchan(cval%), chks, 1))
                tcpSendData chks2, ":" + FullHostMask(fval%) + " MODE " + chans(cval%) + " :-a " + nick(nval%) + CHR$(13) + CHR$(10)
        NEXT chks
END IF
END SUB

SUB makedeop (cval%, nval%, fval%)
'channel, nick to deop, who requested it

xpd = INSTR(1, userchanmodes(nval%, cval%), "o")

IF xpd > 0 THEN
        userchanmodes(nval%, cval%) = LEFT$(userchanmodes(nval%, cval%), xpd - 1) + MID$(userchanmodes(nval%, cval%), xpd + 1)
        FOR chks = 1 TO LEN(nicksinchan(cval%))
                chks2 = ASC(MID$(nicksinchan(cval%), chks, 1))
                tcpSendData chks2, ":" + FullHostMask(fval%) + " MODE " + chans(cval%) + " :-o " + nick(nval%) + CHR$(13) + CHR$(10)
        NEXT chks
END IF
END SUB

SUB makedeowner (cval%, nval%, fval%)
'channel, nick to deowner, who requested it

xpd = INSTR(1, userchanmodes(nval%, cval%), "q")

IF xpd > 0 THEN
        userchanmodes(nval%, cval%) = LEFT$(userchanmodes(nval%, cval%), xpd - 1) + MID$(userchanmodes(nval%, cval%), xpd + 1)
        FOR chks = 1 TO LEN(nicksinchan(cval%))
                chks2 = ASC(MID$(nicksinchan(cval%), chks, 1))
                tcpSendData chks2, ":" + FullHostMask(fval%) + " MODE " + chans(cval%) + " :-q " + nick(nval%) + CHR$(13) + CHR$(10)
        NEXT chks
END IF
END SUB

SUB makedevoice (cval%, nval%, fval%)
'channel, nick to deop, who requested it

xpd = INSTR(1, userchanmodes(nval%, cval%), "v")

IF xpd > 0 THEN
        userchanmodes(nval%, cval%) = LEFT$(userchanmodes(nval%, cval%), xpd - 1) + MID$(userchanmodes(nval%, cval%), xpd + 1)
        FOR chks = 1 TO LEN(nicksinchan(cval%))
                chks2 = ASC(MID$(nicksinchan(cval%), chks, 1))
                tcpSendData chks2, ":" + FullHostMask(fval%) + " MODE " + chans(cval%) + " :-v " + nick(nval%) + CHR$(13) + CHR$(10)
        NEXT chks
END IF
END SUB

FUNCTION MakeLink$ (linkurl$)
MakeLink$ = "<a href=" + CHR$(34) + linkurl$ + CHR$(34) + ">"
END FUNCTION

DEFSNG A-Z
FUNCTION MakeReg% (h AS INTEGER, l AS INTEGER)
MakeReg% = CVI(CHR$(l) + CHR$(h))
END FUNCTION

DEFINT A-Z
FUNCTION Masker$ (actual$)
tempcat$ = "TEMPORARYthingFORmaskingHOSTS" 'lol. make better laterz.
tempmask$ = ""
catpos = 1
FOR nmask = 1 TO LEN(actual$)
        tmv = ASC(MID$(actual$, nmask, 1)) XOR ASC(MID$(tempcat$, catpos, 1))
        tempmask$ = tempmask$ + RIGHT$(HEX$(tmv), 1)
        catpos = catpos + 1
        IF catpos > LEN(tempcat$) THEN catpos = 1
NEXT nmask
Masker$ = tempmask$
END FUNCTION

FUNCTION matchban% (chknick%, chkmask$)
IF INSTR(1, chkmask$, "!") < 1 THEN chkmask$ = nick(chknick%) + "!*@*"
IF INSTR(1, chkmask$, "@") < 1 THEN matchban% = 0: EXIT FUNCTION
xp = INSTR(1, chkmask$, "!")
nn$ = LEFT$(chkmask$, xp - 1): chkmask$ = MID$(chkmask$, xp + 1)
xp = INSTR(1, chkmask$, "@")
uu$ = LEFT$(chkmask$, xp - 1)
hh$ = MID$(chkmask$, xp + 1)

IF LCASE$(nick(chknick%)) = LCASE$(nn$) OR nn$ = "*" THEN matchnick = 1 ELSE matchnick = 0
IF LCASE$(vhost(chknick%)) = LCASE$(uu$) OR uu$ = "*" THEN matchuser = 1 ELSE matchuser = 0
IF LCASE$(userhost(chknick%)) = LCASE$(hh$) OR hh$ = "*" THEN matchhost = 1 ELSE matchhost = 0

IF matchnick = 1 AND matchuser = 1 AND matchhost = 1 THEN matchban% = 1 ELSE matchban% = 0
END FUNCTION

DEFSNG A-Z
SUB nickchanger (whichuser%, changeto$)
useline$ = ":" + nick(whichuser%) + " NICK " + changeto$ + CHR$(13) + CHR$(10)
tcpSendData whichuser%, useline$
nick(whichuser%) = changeto$

IF INSTR(1, usermodes(whichuser%), "u") THEN remusermode whichuser%, "u"

told$ = CHR$(whichuser%)
FOR ch = 1 TO maxchannel%
        IF chans(ch) <> "" AND INSTR(1, nicksinchan(ch), CHR$(whichuser%)) > 0 THEN
                FOR chu = 1 TO LEN(nicksinchan(ch))
                        curusr% = ASC(MID$(nicksinchan(ch), chu, 1))
                        IF curusr% <> whichuser% AND INSTR(1, told$, CHR$(curusr%)) < 1 THEN
                                tcpSendData curusr%, useline$
                                told$ = told$ + CHR$(curusr%)
                        END IF
                NEXT chu
        END IF
NEXT ch
END SUB

FUNCTION nickinuse% (checkname$)
nickinuse% = 0

SELECT CASE LCASE$(checkname$)
        CASE "nickserv", "chanserv", "operserv", "memoserv", "system"
        nickinuse% = 1
        EXIT FUNCTION
END SELECT

IF LEFT$(LCASE$(checkname$), 7) = "no_nick" THEN nickinuse% = 1: EXIT FUNCTION

FOR numb = 0 TO maxhand - 1
        IF LCASE$(nick(numb)) = LCASE$(checkname$) THEN nickinuse% = 1: EXIT FUNCTION
NEXT numb
END FUNCTION

DEFINT A-Z
SUB OutBuffer (whichuser%, txtbuff$)
SendBuffer(whichuser%) = SendBuffer(whichuser%) + txtbuff$
END SUB

FUNCTION ParseHelp$ (origtext$)
tmphelp$ = ""
FOR nuh = 1 TO LEN(origtext$)
        cc$ = MID$(origtext$, nuh, 1)
        SELECT CASE cc$
                CASE CHR$(10), CHR$(0), ""
                CASE ELSE
                tmphelp$ = tmphelp$ + cc$
        END SELECT
NEXT nuh
ParseHelp = tmphelp$
tmphelp$ = ""
END FUNCTION

DEFSNG A-Z
SUB RegBlank
tcpCall.ax = 0
tcpCall.bx = 0
tcpCall.cx = 0
tcpCall.dx = 0
tcpCall.bp = 0
tcpCall.si = 0
tcpCall.di = 0
tcpCall.flags = 0
tcpCall.ds = 0
tcpCall.es = 0
END SUB

SUB remfromchan (whichchan%, whichnick%, quitmsg$)
IF whichnick% > 9999 THEN
        whichnick% = whichnick% - 10000
        displaymsg = 0
        tcpSendData whichnick%, ":" + nick(whichnick%) + " PART " + chans(whichchan%) + quitmsg$ + CHR$(13) + CHR$(10)
ELSE
        displaymsg = 1
END IF

xp = INSTR(1, nicksinchan(whichchan%), CHR$(whichnick%))
IF xp > 0 THEN
        nicksinchan(whichchan%) = LEFT$(nicksinchan(whichchan%), xp - 1) + MID$(nicksinchan(whichchan%), xp + 1)
        FOR nu = 1 TO LEN(nicksinchan(whichchan%))
                IF displaymsg = 0 THEN
                        tcpSendData hands(ASC(MID$(nicksinchan(whichchan%), nu, 1))), ":" + nick(whichnick%) + " PART " + chans(whichchan%) + quitmsg$ + CHR$(13) + CHR$(10)
                ELSE
                        tmphan% = hands(ASC(MID$(nicksinchan(whichchan%), nu, 1)))
                        IF tmphan% <> whichnick% THEN tcpSendData tmphan%, ":" + nick(whichnick%) + " QUIT :" + quitmsg$ + CHR$(13) + CHR$(10)
                END IF
        NEXT nu
        IF displaymsg = 1 THEN tcpSendData whichnick%, ":" + nick(whichnick%) + " PART " + chans(whichchan%) + CHR$(13) + CHR$(10)
END IF

IF nicksinchan(whichchan%) = "" THEN killchannel whichchan%
END SUB

DEFINT A-Z
SUB remusermode (handval%, chkmode$)
deld$ = ""
FOR chkem = 1 TO LEN(chkmode$)
        chksingle$ = MID$(chkmode$, chkem, 1)
        xp = INSTR(1, usermodes(handval%), chksingle$)
        IF xp > 0 THEN
                usermodes(handval%) = LEFT$(usermodes(handval%), xp - 1) + MID$(usermodes(handval%), xp + 1)
                deld$ = deld$ + chksingle$
                IF chksingle$ = "x" THEN vhost(handval%) = tcpRemoteIP(handval%)
        END IF
NEXT chkem
IF deld$ <> "" THEN
        tcpSendData handval%, ":" + localdomain$ + " MODE " + nick(handval%) + " :-" + deld$ + CHR$(13) + CHR$(10)
END IF
END SUB

SUB SendError (sckhand, errnum, comd$)
SELECT CASE errnum
        CASE 401 'no such nick/channel
                dsc$ = "No such nick/channel (" + comd$ + ")"
        CASE 402 'no such server
                dsc$ = "No such server"
        CASE 404 'cannot send to channel
                dsc$ = "Cannot send to channel (you are not in the channel, or you don't have +v in a +m moderated channel)"
        CASE 421 'unknown command
                dsc$ = "Unknown command (" + comd$ + ")"
        CASE 433 'nickname already in use
                dsc$ = "Nickname already in use"
        CASE 442 'you're not on that channel
                dsc$ = "You're not on that channel"
        CASE 451 'you have not registered
                dsc$ = "You have not registered"
        CASE 461 'not enough params
                dsc$ = "Not enough parameters"
        CASE 462 'you may not reregister
                dsc$ = "You may not reregister"
        CASE 466 'USERS disabled
                dsc$ = "USERS has been disabled"
        CASE 481 'not an IRCop
                dsc$ = "Permission denied - you're not an IRC operator"
        CASE 482 'not a channel op
                dsc$ = comd$ + " :You're not channel operator"
END SELECT

IF comd$ = "" THEN
        fl$ = ":" + localdomain$ + STR$(errnum) + " :" + dsc$ + CHR$(13) + CHR$(10)
ELSE
        fl$ = ":" + localdomain$ + STR$(errnum) + " " + comd$ + " :" + dsc$ + CHR$(13) + CHR$(10)
END IF

tcpSendData sckhand, fl$
END SUB

SUB ShowUserModes (handval%)
tcpSendData handval%, ":" + nick(handval%) + " MODE " + nick(handval%) + " :+" + usermodes(handval%) + CHR$(13) + CHR$(10)
END SUB

DEFSNG A-Z
SUB tcpClose (tcpHandle AS INTEGER)
tcpCall.ax = MakeReg(&H11, 0)
tcpCall.bx = tcpHandle
tcpCall.dx = 1 'tcpDriver.Timeout

CALL interruptx(tcpDriver.IntVector, tcpCall, tcpReturn)
tcpDriver.ErrorCode = LowByte(tcpReturn.dx)
tcpDoIO
END SUB

FUNCTION tcpConnect% (RemoteIP AS STRING, RemotePort AS INTEGER)
DIM tempRemoteIP AS STRING
tempRemoteIP = Conv2DWord(RemoteIP)

tcpCall.ax = MakeReg(&H10, 0)
tcpCall.bx = 0
tcpCall.cx = RemotePort
tcpCall.dx = tcpDriver.Timeout
tcpCall.di = CVI(LEFT$(tempRemoteIP, 2))
tcpCall.si = CVI(RIGHT$(tempRemoteIP, 2))
CALL interruptx(tcpDriver.IntVector, tcpCall, tcpReturn)

dummyLocalPortNr% = tcpReturn.ax
'PRINT "Local port:"; dummyLocalPortNr%

tcpConnect% = tcpReturn.bx 'Makes this function return the TCPDRV handle number.
tcpDriver.ErrorCode = LowByte(tcpReturn.dx)

tcpDoIO
END FUNCTION

SUB tcpDoIO
'Allows TCPDRV to perform processing of data. THIS MUST BE CALLED REGULARLY
'for packets to be processed! If you don't do this, TCPDRV will eventually
'crash when it runs out of storage space for input and output queues.

RegBlank

tcpCall.ax = MakeReg(&H2, 0)
'tcpCall.dx = 0 'tcpDriver.Timeout
CALL interruptx(tcpDriver.IntVector, tcpCall, tcpReturn)

tcpDriver.ErrorCode = LowByte(tcpReturn.dx)
END SUB

FUNCTION tcpGetData$ (tcpHandle AS INTEGER)
stat = tcpStatus(tcpHandle)
IF stat <> sckOpen THEN
        tcpClose tcpHandle
        EXIT FUNCTION
END IF

tcpCall.ax = MakeReg(&H12, 1)
tcpCall.bx = tcpHandle
tcpCall.es = VARSEG(strGetData)
tcpCall.di = VARPTR(strGetData)
tcpCall.cx = 1024
tcpCall.dx = 1 'tcpDriver.Timeout
CALL interruptx(tcpDriver.IntVector, tcpCall, tcpReturn)
tcpGetData$ = LEFT$(strGetData, tcpReturn.ax)

tcpDriver.ErrorCode = LowByte(tcpReturn.dx)

tcpDoIO
END FUNCTION

FUNCTION tcpInBuffer% (tcpHandle AS INTEGER)
dummy1% = tcpStatus%(tcpHandle)
IF isActive > 0 THEN
        tcpInBuffer% = tcpReturn.ax
END IF
tcpDriver.ErrorCode = LowByte(tcpReturn.dx)
END FUNCTION

FUNCTION tcpInit% (Vector AS INTEGER)
'If given vector value is zero, assume the usual vector 61h.
IF Vector = 0 THEN Vector = &H61

tcpCall.ax = MakeReg(&H0, &HFF)
CALL interruptx(Vector, tcpCall, tcpReturn)

'This next line sets tcpDriver.Enabled to zero, sets the tcpInit function
'return value to zero, and exits the function immediately if the interrupt
'call did not return the expected value of zero for a functional TCPDRV
'vector at the specified segment.
IF tcpReturn.ax <> 0 THEN tcpDriver.Enabled = 0: tcpInit% = 0: EXIT FUNCTION

tcpInit% = 1
tcpDriver.Enabled = 1
tcpDriver.IntVector = Vector
DEF SEG = tcpReturn.es
offset = tcpReturn.di

'The following lines of code parse all of the network-related data
'from the pointer value returned by TCPDRV.
tcpDriver.LocalIP = CVL(CHR$(PEEK(offset)) + CHR$(PEEK(offset + 1)) + CHR$(PEEK(offset + 2)) + CHR$(PEEK(offset + 3)))
offset = offset + 4

tcpDriver.LocalNetmask = CVL(CHR$(PEEK(offset)) + CHR$(PEEK(offset + 1)) + CHR$(PEEK(offset + 2)) + CHR$(PEEK(offset + 3)))
offset = offset + 4

tcpDriver.LocalGateway = CVL(CHR$(PEEK(offset)) + CHR$(PEEK(offset + 1)) + CHR$(PEEK(offset + 2)) + CHR$(PEEK(offset + 3)))
offset = offset + 4

tcpDriver.LocalDNS = CVL(CHR$(PEEK(offset)) + CHR$(PEEK(offset + 1)) + CHR$(PEEK(offset + 2)) + CHR$(PEEK(offset + 3)))
offset = offset + 4

tcpDriver.Timeserver = CVL(CHR$(PEEK(offset)) + CHR$(PEEK(offset + 1)) + CHR$(PEEK(offset + 2)) + CHR$(PEEK(offset + 3)))
offset = offset + 4

tcpDriver.MTU = CVI(CHR$(PEEK(offset)) + CHR$(PEEK(offset + 1)))
offset = offset + 2

tcpDriver.TTL = PEEK(offset)
tcpDriver.TOS = PEEK(offset + 1)
offset = offset + 4 'Skip two unused bytes after TTL and TOS data.

tcpDriver.MSS = CVI(CHR$(PEEK(offset)) + CHR$(PEEK(offset + 1)))
offset = offset + 2

tcpDriver.RWIN = CVI(CHR$(PEEK(offset)) + CHR$(PEEK(offset + 1)))
offset = offset + 4 'Skip two unused bytes after RWIN data.

'The following code segment gets the local domain string.
'TCPDRV allocates 256 bytes for this string, because that is the maximum
'allowed length of a domain name. If the string is shorter than 256 bytes,
'then TCPDRV fills the remainder of the string with ASCII code 255. The
'following code stops reading from the domain string as soon is it sees
'the first byte with a value of 255 for performance reasons.
DIM tempNum AS INTEGER
DIM tempCurByte AS STRING * 1
DIM tempstr AS STRING
FOR tempNum = offset TO offset + 255
        tempCurByte = CHR$(PEEK(tempNum))
        IF tempCurByte = CHR$(255) THEN
                tcpDriver.DomainLen = tempNum - offset
                tcpDriver.localdomain = tempstr
        ELSE
                tempstr = tempstr + tempCurByte
        END IF
NEXT tempNum

tcpDriver.ErrorCode = LowByte(tcpReturn.dx)
END FUNCTION

FUNCTION tcpListen% (ListenPort AS INTEGER)
tcpCall.ax = MakeReg(&H10, 1)
tcpCall.bx = ListenPort
tcpCall.cx = 0
tcpCall.dx = tcpDriver.Timeout
tcpCall.si = 0
tcpCall.di = 0
CALL interruptx(tcpDriver.IntVector, tcpCall, tcpReturn)

tcpListen% = tcpReturn.bx
tcpDriver.ErrorCode = LowByte(tcpReturn.dx)

tcpDoIO
END FUNCTION

DEFINT A-Z
FUNCTION tcpRemoteIP$ (tcpHandle AS INTEGER)
checkstat% = tcpStatus(tcpHandle)
IF checkstat% <> sckOpen THEN tcpRemoteIP$ = "0.0.0.0": EXIT FUNCTION

DEF SEG = tcpReturn.es
stateoffset = tcpReturn.di
ipdest$ = Conv2IP(CVL(CHR$(PEEK(stateoffset + 6)) + CHR$(PEEK(stateoffset + 7)) + CHR$(PEEK(stateoffset + 8)) + CHR$(PEEK(stateoffset + 9))))
'ipsrce$ = Conv2IP(CVL(CHR$(PEEK(stateoffset)) + CHR$(PEEK(stateoffset + 1)) + CHR$(PEEK(stateoffset + 2)) + CHR$(PEEK(stateoffset + 3))))

tcpRemoteIP$ = ipdest$
END FUNCTION

DEFSNG A-Z
SUB tcpSendData (tcpHandle AS INTEGER, Data2Send AS STRING)
'IF INSTR(1, UCASE$(COMMAND$), "/DEBUGLOG") > 0 THEN
'        t2s$ = DATE$ + " " + TIME$ + " - Node" + STR$(tcpHandle) + " OUTGOING - " + Data2Send$
'        IF LEN(t2s$) > 42 THEN
'                OPEN "debug.log" FOR APPEND AS #9
'                PRINT #9, t2s$;
'                CLOSE #9
'        END IF
'END IF

DO UNTIL Data2Send = ""
        stat = tcpStatus(tcpHandle)
        IF stat <> sckOpen THEN
                tcpClose tcpHandle
                EXIT SUB
        END IF

        strSendData = LEFT$(Data2Send, 1024)
        tmpval = LEN(Data2Send)
        IF tmpval > 1024 THEN tmpval = 1024

        tcpCall.ax = MakeReg(&H13, 4)
        tcpCall.bx = tcpHandle
        tcpCall.es = INT(VARSEG(strSendData))
        tcpCall.di = INT(VARPTR(strSendData))
        tcpCall.cx = INT(tmpval)
        tcpCall.dx = 0 'tcpDriver.Timeout
        CALL interruptx(tcpDriver.IntVector, tcpCall, tcpReturn)

        tcpDriver.ErrorCode = LowByte(tcpReturn.dx)
        tcpDoIO
        Data2Send = MID$(Data2Send, 1025)
LOOP
END SUB

SUB tcpSetTimeout (TimeoutSeconds AS INTEGER)
tcpDriver.Timeout = INT(TimeoutSeconds * 18.2)
END SUB

FUNCTION tcpStatus% (tcpHandle AS INTEGER)
tcpDoIO

tcpCall.ax = MakeReg(&H14, 0)
tcpCall.bx = tcpHandle
CALL interruptx(tcpDriver.IntVector, tcpCall, tcpReturn)

DEF SEG = tcpReturn.es
stateoffset = tcpReturn.di
ipsrce$ = Conv2IP(CVL(CHR$(PEEK(stateoffset)) + CHR$(PEEK(stateoffset + 1)) + CHR$(PEEK(stateoffset + 2)) + CHR$(PEEK(stateoffset + 3))))
ipdest$ = Conv2IP(CVL(CHR$(PEEK(stateoffset + 4)) + CHR$(PEEK(stateoffset + 5)) + CHR$(PEEK(stateoffset + 6)) + CHR$(PEEK(stateoffset + 7))))
ipprot% = PEEK(stateoffset + 8)
active% = PEEK(stateoffset + 9)
ifActive = active%
'PRINT "======================"
'PRINT "Debug: Status data return values for TCP handle"; tcpHandle
'PRINT
'PRINT "Error code:"; LowByte(tcpReturn.dx)
'PRINT "TCP state:"; HighByte(tcpReturn.dx)
'PRINT
'PRINT "Bytes available for reading:"; tcpReturn.ax
'PRINT "Bytes still being transmitted:"; tcpReturn.cx
'PRINT
'PRINT "Session info gathered from pointer" + STR$(tcpReturn.es) + ":" + MID$(STR$(tcpReturn.di), 2)
'PRINT "IP source: " + ipsrce$
'PRINT "IP dest: " + ipsrce$
'PRINT "IP prot:"; ipprot%
'PRINT "Active:"; active%
'PRINT "======================"
tcpStatus% = HighByte(tcpReturn.dx)
tcpDriver.ErrorCode = LowByte(tcpReturn.dx)
END FUNCTION

SUB tcpUnload
tcpCall.ax = MakeReg(&H1, 0)
CALL interruptx(tcpDriver.IntVector, tcpCall, tcpReturn)

tcpDriver.Enabled = 0
END SUB

DEFLNG A-Z
FUNCTION UnixTimeEnc& (dateval AS STRING, timeval AS LONG)
DIM temptime AS LONG
tempdate$ = dateval
divider = INSTR(1, tempdate$, "-"): month = VAL(LEFT$(tempdate$, divider - 1))
tempdate$ = MID$(tempdate$, divider + 1)
divider = INSTR(1, tempdate$, "-"): day = VAL(LEFT$(tempdate$, divider - 1))
tempdate$ = MID$(tempdate$, divider + 1)
year = VAL(tempdate$)

temptime = 0
FOR calcval = 1970 TO year - 1
   'determine if a year is a leap year
   IF (calcval + 2) / 4 = FIX((calcval + 2) / 4) THEN
      daysinyear = 366
   ELSE
      daysinyear = 365
   END IF

   temptime = temptime + (daysinyear * 86400)
NEXT calcval

FOR calcval = 1 TO month - 1
   SELECT CASE calcval
      CASE 1 'Jan = 31 days
         temptime = temptime + (31 * 86400)

      CASE 2 'Feb = 28 days in common year, 29 days in leap year
         IF (year + 2) / 4 = FIX((year + 2) / 4) THEN 'it's a leap year
            temptime = temptime + (29 * 86400)
         ELSE 'it's a common year
            temptime = temptime + (28 * 86400)
      END IF

      CASE 3 'Mar = 31 days
         temptime = temptime + (31 * 86400)

      CASE 4 'Apr = 30 days
         temptime = temptime + (30 * 86400)

      CASE 5 'May = 31 days
         temptime = temptime + (31 * 86400)

      CASE 6 'Jun = 30 days
         temptime = temptime + (30 * 86400)

      CASE 7 'Jul = 31 days
         temptime = temptime + (31 * 86400)

      CASE 8 'Aug = 31 days
         temptime = temptime + (31 * 86400)

      CASE 9 'Sep = 30 days
         temptime = temptime + (30 * 86400)

      CASE 10 'Oct = 31 days
         temptime = temptime + (31 * 86400)

      CASE 11 'Nov = 31 days
         temptime = temptime + (31 * 86400)
   END SELECT
NEXT calcval

temptime = temptime + ((day - 1) * 86400) + timeval + (-timezone * 3600)
UnixTimeEnc& = temptime
END FUNCTION

DEFSNG A-Z
FUNCTION userlist$ (whichchan AS INTEGER)
templist$ = ""
FOR nt = 1 TO LEN(nicksinchan(whichchan))
        nickvalue% = ASC(MID$(nicksinchan(whichchan), nt, 1))
        prefix$ = ""
        IF INSTR(1, userchanmodes(nickvalue%, whichchan), "v") THEN prefix$ = "+"
        IF INSTR(1, userchanmodes(nickvalue%, whichchan), "h") THEN prefix$ = "%"
        IF INSTR(1, userchanmodes(nickvalue%, whichchan), "o") THEN prefix$ = "@"
        IF INSTR(1, userchanmodes(nickvalue%, whichchan), "a") THEN prefix$ = "&"
        IF INSTR(1, userchanmodes(nickvalue%, whichchan), "q") THEN prefix$ = "~"
        templist$ = templist$ + prefix$ + nick(nickvalue%) + " "
NEXT nt
IF RIGHT$(templist$, 1) = " " THEN templist$ = LEFT$(templist$, LEN(templist$) - 1)
userlist$ = templist$
END FUNCTION

DEFINT A-Z
FUNCTION validchan$ (chantocheck$)
IF LEFT$(chantocheck$, 1) <> "#" THEN chantocheck$ = "#" + chantocheck$
newchan$ = "#"
FOR nvc = 2 TO LEN(chantocheck$)
        cnc$ = MID$(chantocheck$, nvc, 1)
        IF INSTR(1, allowchan$, cnc$) > 0 THEN newchan$ = newchan$ + cnc$
NEXT nvc
validchan$ = newchan$
END FUNCTION

FUNCTION validnick$ (nicktocheck$)
newnick$ = ""
FOR nvc = 1 TO LEN(nicktocheck$)
        cnc$ = MID$(nicktocheck$, nvc, 1)
        IF INSTR(1, allownick$, cnc$) > 0 THEN newnick$ = newnick$ + cnc$
NEXT nvc
validnick$ = newnick$
END FUNCTION

